/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.gui.ContainerDummy;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryConcatenator;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.CraftingUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAutoWorkbench
extends TileBuildCraft
implements ISidedInventory,
IHasWork,
IRedstoneEngineReceiver,
IDebuggable {
    public static final int SLOT_RESULT = 9;
    public static final int CRAFT_TIME = 256;
    public static final int UPDATE_TIME = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 10);
    public int progress = 0;
    public LocalInventoryCrafting craftMatrix = new LocalInventoryCrafting();
    private SimpleInventory resultInv = new SimpleInventory(1, "Auto Workbench", 64);
    private SimpleInventory inputInv = new SimpleInventory(9, "Auto Workbench", 64){

        @Override
        public void setInventorySlotContents(int slotId, ItemStack itemstack) {
            super.setInventorySlotContents(slotId, itemstack);
            if (TileAutoWorkbench.this.craftMatrix.isInputMissing && this.getStackInSlot(slotId) != null) {
                TileAutoWorkbench.this.craftMatrix.isInputMissing = false;
            }
        }

        @Override
        public void markDirty() {
            super.markDirty();
            TileAutoWorkbench.this.craftMatrix.isInputMissing = false;
        }
    };
    private IInventory inv = InventoryConcatenator.make().add(this.inputInv).add(this.resultInv).add((IInventory)this.craftMatrix);
    private SlotCrafting craftSlot;
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    private int[] bindings = new int[9];
    private int[] bindingCounts = new int[9];
    private int update = Utils.RANDOM.nextInt();
    private boolean hasWork = false;
    private boolean scheduledCacheRebuild = false;

    public TileAutoWorkbench() {
        this.setBattery(new RFBattery(16, 16, 0));
    }

    @Override
    public boolean hasWork() {
        return this.hasWork;
    }

    @Override
    public boolean canConnectRedstoneEngine(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection side) {
        TileEntity tile = this.worldObj.getTileEntity(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ);
        return tile instanceof IRedstoneEngine;
    }

    @Override
    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        info.add("isInputMissing = " + this.craftMatrix.isInputMissing);
        info.add("isOutputJammed = " + this.craftMatrix.isOutputJammed);
    }

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord);
    }

    public void markDirty() {
        super.markDirty();
        this.inv.markDirty();
    }

    public int getSizeInventory() {
        return 10;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int count) {
        return this.inv.decrStackSize(slot, count);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(slot, stack);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public String getInventoryName() {
        return "";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.resultInv.readFromNBT(data);
        if (data.hasKey("input")) {
            InvUtils.readInvFromNBT(this.inputInv, "input", data);
            InvUtils.readInvFromNBT((IInventory)this.craftMatrix, "matrix", data);
        } else {
            InvUtils.readInvFromNBT(this.inputInv, "matrix", data);
            for (int i = 0; i < 9; ++i) {
                ItemStack inputStack = this.inputInv.getStackInSlot(i);
                if (inputStack == null) continue;
                ItemStack matrixStack = inputStack.copy();
                matrixStack.stackSize = 1;
                this.craftMatrix.setInventorySlotContents(i, matrixStack);
            }
        }
        this.craftMatrix.rebuildCache();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.resultInv.writeToNBT(data);
        InvUtils.writeInvToNBT(this.inputInv, "input", data);
        InvUtils.writeInvToNBT((IInventory)this.craftMatrix, "matrix", data);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.scheduledCacheRebuild) {
            this.craftMatrix.rebuildCache();
            this.scheduledCacheRebuild = false;
        }
        if (this.craftMatrix.isOutputJammed || this.craftMatrix.isInputMissing || this.craftMatrix.currentRecipe == null) {
            this.progress = 0;
            return;
        }
        if (this.craftSlot == null) {
            this.craftSlot = new SlotCrafting((EntityPlayer)this.getInternalPlayer().get(), (IInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 0, 0);
        }
        if (!this.hasWork) {
            return;
        }
        int updateNext = this.update + this.getBattery().getEnergyStored() + 1;
        int updateThreshold = (this.update & 0xFFFFFFF0) + 16;
        this.update = Math.min(updateThreshold, updateNext);
        if (this.update % 16 == 0) {
            this.updateCrafting();
        }
        this.getBattery().setEnergy(0);
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 256;
    }

    private void updateCrafting() {
        int i;
        this.progress += 16;
        for (i = 0; i < 9; ++i) {
            this.bindingCounts[i] = 0;
        }
        for (i = 0; i < 9; ++i) {
            ItemStack comparedStack = this.craftMatrix.getStackInSlot(i);
            if (comparedStack == null || comparedStack.getItem() == null) {
                this.bindings[i] = -1;
                continue;
            }
            if (this.bindings[i] == -1 || !StackHelper.isMatchingItem(this.inputInv.getStackInSlot(this.bindings[i]), comparedStack, true, true)) {
                boolean found = false;
                for (int j = 0; j < 9; ++j) {
                    ItemStack inputInvStack;
                    if (j == this.bindings[i] || !StackHelper.isMatchingItem(inputInvStack = this.inputInv.getStackInSlot(j), comparedStack, true, false) || inputInvStack.stackSize <= this.bindingCounts[j]) continue;
                    found = true;
                    this.bindings[i] = j;
                    int n = j;
                    this.bindingCounts[n] = this.bindingCounts[n] + 1;
                    break;
                }
                if (found) continue;
                this.craftMatrix.isInputMissing = true;
                this.progress = 0;
                return;
            }
            int n = this.bindings[i];
            this.bindingCounts[n] = this.bindingCounts[n] + 1;
        }
        for (i = 0; i < 9; ++i) {
            ItemStack stack;
            if (this.bindingCounts[i] <= 0 || (stack = this.inputInv.getStackInSlot(i)) == null || stack.stackSize >= this.bindingCounts[i]) continue;
            for (int j = 0; j < 9; ++j) {
                if (this.bindings[j] != i) continue;
                this.bindings[j] = -1;
            }
            return;
        }
        if (this.progress < 256) {
            return;
        }
        this.progress = 0;
        this.craftMatrix.setUseBindings(true);
        ItemStack result = this.craftMatrix.getRecipeOutput();
        if (result != null && result.stackSize > 0) {
            ItemStack resultInto = this.resultInv.getStackInSlot(0);
            this.craftSlot.onPickupFromSlot((EntityPlayer)this.getInternalPlayer().get(), result);
            if (resultInto == null) {
                this.resultInv.setInventorySlotContents(0, result);
            } else {
                resultInto.stackSize += result.stackSize;
            }
        }
        this.craftMatrix.setUseBindings(false);
        this.craftMatrix.rebuildCache();
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 9) {
            return false;
        }
        return !stack.getItem().hasContainerItem(stack);
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (slot >= 9) {
            return false;
        }
        ItemStack slotStack = this.inv.getStackInSlot(slot);
        if (StackHelper.canStacksMerge(stack, slotStack)) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack inputStack = this.craftMatrix.getStackInSlot(i);
            if (inputStack == null || !StackHelper.isMatchingItem(inputStack, stack, true, false)) continue;
            return true;
        }
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 9;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public class LocalInventoryCrafting
    extends InventoryCrafting {
        public IRecipe currentRecipe;
        public boolean useBindings;
        public boolean isOutputJammed;
        public boolean isInputMissing;

        public LocalInventoryCrafting() {
            super((Container)new ContainerDummy(), 3, 3);
        }

        public ItemStack getStackInSlot(int slot) {
            if (this.useBindings) {
                if (slot >= 0 && slot < 9 && TileAutoWorkbench.this.bindings[slot] >= 0) {
                    return TileAutoWorkbench.this.inputInv.getStackInSlot(TileAutoWorkbench.this.bindings[slot]);
                }
                return null;
            }
            return super.getStackInSlot(slot);
        }

        public ItemStack getRecipeOutput() {
            this.currentRecipe = this.findRecipe();
            if (this.currentRecipe == null) {
                return null;
            }
            ItemStack result = this.currentRecipe.getCraftingResult((InventoryCrafting)this);
            if (result != null) {
                result = result.copy();
            }
            return result;
        }

        private IRecipe findRecipe() {
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this, ForgeDirection.UP)) {
                ItemStack stack = slot.getStackInSlot();
                if (stack == null || !stack.getItem().hasContainerItem(stack)) continue;
                return null;
            }
            return CraftingUtils.findMatchingRecipe(TileAutoWorkbench.this.craftMatrix, TileAutoWorkbench.this.worldObj);
        }

        public void rebuildCache() {
            this.currentRecipe = this.findRecipe();
            TileAutoWorkbench.this.hasWork = this.currentRecipe != null && this.currentRecipe.getRecipeOutput() != null;
            ItemStack result = this.getRecipeOutput();
            ItemStack resultInto = TileAutoWorkbench.this.resultInv.getStackInSlot(0);
            this.isOutputJammed = resultInto != null && (!StackHelper.canStacksMerge(resultInto, result) || resultInto.stackSize + result.stackSize > resultInto.getMaxStackSize());
        }

        public void setInventorySlotContents(int slot, ItemStack stack) {
            if (this.useBindings) {
                if (slot >= 0 && slot < 9 && TileAutoWorkbench.this.bindings[slot] >= 0) {
                    TileAutoWorkbench.this.inputInv.setInventorySlotContents(TileAutoWorkbench.this.bindings[slot], stack);
                }
                return;
            }
            super.setInventorySlotContents(slot, stack);
            TileAutoWorkbench.this.scheduledCacheRebuild = true;
        }

        public void markDirty() {
            super.markDirty();
            TileAutoWorkbench.this.scheduledCacheRebuild = true;
        }

        public ItemStack decrStackSize(int slot, int amount) {
            if (this.useBindings) {
                if (slot >= 0 && slot < 9 && TileAutoWorkbench.this.bindings[slot] >= 0) {
                    return TileAutoWorkbench.this.inputInv.decrStackSize(TileAutoWorkbench.this.bindings[slot], amount);
                }
                return null;
            }
            TileAutoWorkbench.this.scheduledCacheRebuild = true;
            return this.decrStackSize(slot, amount);
        }

        public void setUseBindings(boolean use) {
            this.useBindings = use;
        }
    }
}

