/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.Transactor;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileHopper
extends TileBuildCraft
implements IInventory,
IEnergyHandler,
IRedstoneEngineReceiver {
    private final SimpleInventory inventory = new SimpleInventory(4, "Hopper", 64);
    private boolean isEmpty;

    @Override
    public void initialize() {
        this.setBattery(new RFBattery(10, 10, 0));
        this.inventory.addListener(this);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagCompound p = nbtTagCompound;
        if (nbtTagCompound.hasKey("inventory")) {
            p = nbtTagCompound.getCompoundTag("inventory");
        }
        this.inventory.readFromNBT(p);
        this.inventory.markDirty();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        this.inventory.writeToNBT(nbtTagCompound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote || this.isEmpty || this.worldObj.getTotalWorldTime() % 2L != 0L) {
            return;
        }
        TileEntity outputTile = this.getTile(ForgeDirection.DOWN);
        ITransactor transactor = Transactor.getTransactorFor(outputTile);
        if (transactor == null) {
            if (outputTile instanceof IInjectable && this.getBattery().getEnergyStored() >= 10) {
                int used;
                int internalSlot;
                ItemStack stackToOutput = null;
                this.getBattery().useEnergy(10, 10, false);
                for (internalSlot = 0; internalSlot < this.inventory.getSizeInventory(); ++internalSlot) {
                    ItemStack stackInSlot = this.inventory.getStackInSlot(internalSlot);
                    if (stackInSlot == null || stackInSlot.stackSize == 0) continue;
                    stackToOutput = stackInSlot.copy();
                    stackToOutput.stackSize = 1;
                    break;
                }
                if (stackToOutput != null && (used = ((IInjectable)outputTile).injectItem(stackToOutput, true, ForgeDirection.UP, null)) > 0) {
                    this.decrStackSize(internalSlot, 1);
                }
            }
            return;
        }
        for (int internalSlot = 0; internalSlot < this.inventory.getSizeInventory(); ++internalSlot) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(internalSlot);
            if (stackInSlot == null || stackInSlot.stackSize == 0) continue;
            ItemStack clonedStack = stackInSlot.copy().splitStack(1);
            if (transactor.add((ItemStack)clonedStack, (ForgeDirection)ForgeDirection.UP, (boolean)true).stackSize <= 0) continue;
            this.inventory.decrStackSize(internalSlot, 1);
            return;
        }
    }

    public void markDirty() {
        super.markDirty();
        this.isEmpty = true;
        for (int internalSlot = 0; internalSlot < this.inventory.getSizeInventory(); ++internalSlot) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(internalSlot);
            if (stackInSlot == null || stackInSlot.stackSize <= 0) continue;
            this.isEmpty = false;
            return;
        }
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.inventory.getStackInSlot(slotId);
    }

    public ItemStack decrStackSize(int slotId, int count) {
        ItemStack output = this.inventory.decrStackSize(slotId, count);
        return output;
    }

    public ItemStack getStackInSlotOnClosing(int slotId) {
        ItemStack output = this.inventory.getStackInSlotOnClosing(slotId);
        return output;
    }

    public void setInventorySlotContents(int slotId, ItemStack itemStack) {
        this.inventory.setInventorySlotContents(slotId, itemStack);
    }

    public String getInventoryName() {
        return this.inventory.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && entityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public boolean canConnectRedstoneEngine(ForgeDirection side) {
        return side.ordinal() >= 2;
    }

    @Override
    public String getOwner() {
        return super.getOwner();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection side) {
        return side.ordinal() >= 2 && !(this.getTile(side) instanceof IPipeTile);
    }
}

