/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.BlockMiner;
import buildcraft.core.lib.utils.BlockUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMiningWell
extends TileBuildCraft
implements IHasWork,
IPipeConnection,
IControllable,
ILEDProvider {
    private boolean isDigging = true;
    private BlockMiner miner;
    private int ledState;
    private int ticksSinceAction = 9001;
    private SafeTimeTracker updateTracker = new SafeTimeTracker(BuildCraftCore.updateFactor);

    public TileMiningWell() {
        this.setBattery(new RFBattery(20480, 880, 0));
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.updateTracker.markTimeIfDelay(this.worldObj)) {
            this.sendNetworkUpdate();
        }
        ++this.ticksSinceAction;
        if (this.mode == IControllable.Mode.Off) {
            if (this.miner != null) {
                this.miner.invalidate();
                this.miner = null;
            }
            this.isDigging = false;
            return;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            return;
        }
        if (this.miner == null) {
            World world = this.worldObj;
            int depth = this.yCoord - 1;
            while (world.getBlock(this.xCoord, depth, this.zCoord) == BuildCraftFactory.plainPipeBlock) {
                --depth;
            }
            if (depth < 1 || depth < this.yCoord - BuildCraftFactory.miningDepth || !BlockUtils.canChangeBlock(world, this.xCoord, depth, this.zCoord)) {
                this.isDigging = false;
                this.getBattery().useEnergy(0, 10, false);
                return;
            }
            if (world.isAirBlock(this.xCoord, depth, this.zCoord) || world.getBlock(this.xCoord, depth, this.zCoord).isReplaceable((IBlockAccess)world, this.xCoord, depth, this.zCoord)) {
                this.ticksSinceAction = 0;
                world.setBlock(this.xCoord, depth, this.zCoord, (Block)BuildCraftFactory.plainPipeBlock);
            } else {
                this.miner = new BlockMiner(world, this, this.xCoord, depth, this.zCoord);
            }
        }
        if (this.miner != null) {
            this.isDigging = true;
            this.ticksSinceAction = 0;
            int usedEnergy = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
            this.getBattery().useEnergy(usedEnergy, usedEnergy, false);
            if (this.miner.hasFailed()) {
                this.isDigging = false;
            }
            if (this.miner.hasFailed() || this.miner.hasMined()) {
                this.miner = null;
            }
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.miner != null) {
            this.miner.invalidate();
        }
        if (this.worldObj != null && this.yCoord > 2) {
            BuildCraftFactory.miningWellBlock.removePipes(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.ledState = (this.ticksSinceAction < 2 ? 16 : 0) | this.getBattery().getEnergyStored() * 15 / this.getBattery().getMaxEnergyStored();
        stream.writeByte(this.ledState);
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        short newLedState = stream.readUnsignedByte();
        if (newLedState != this.ledState) {
            this.ledState = newLedState;
            this.worldObj.markBlockRangeForRenderUpdate(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public boolean hasWork() {
        return this.isDigging;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }

    @Override
    public int getLEDLevel(int led) {
        if (led == 0) {
            return this.ledState & 0xF;
        }
        return this.ledState >> 4 > 0 ? 15 : 0;
    }
}

