/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.slots.SlotOutput;
import buildcraft.core.lib.gui.slots.SlotUntouchable;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.gui.SlotWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAutoWorkbench
extends BuildCraftContainer {
    public IInventory craftResult = new InventoryCraftResult();
    private final TileAutoWorkbench tile;
    private int lastProgress;
    private ItemStack prevOutput;

    public ContainerAutoWorkbench(InventoryPlayer inventoryplayer, TileAutoWorkbench t) {
        super(t.getSizeInventory());
        int x;
        int x2;
        int y;
        this.tile = t;
        this.addSlotToContainer(new SlotUntouchable(this.craftResult, 0, 93, 27));
        this.addSlotToContainer(new SlotOutput((IInventory)this.tile, 9, 124, 35));
        for (y = 0; y < 3; ++y) {
            for (x2 = 0; x2 < 3; ++x2) {
                this.addSlotToContainer(new SlotWorkbench((IInventory)this.tile, 10 + x2 + y * 3, 30 + x2 * 18, 17 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlotToContainer(new Slot((IInventory)this.tile, x, 8 + x * 18, 84));
        }
        for (y = 0; y < 3; ++y) {
            for (x2 = 0; x2 < 9; ++x2) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, x2 + y * 9 + 9, 8 + x2 * 18, 115 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, x, 8 + x * 18, 173));
        }
        this.onCraftMatrixChanged((IInventory)this.tile);
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 0, this.tile.progress);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.lastProgress == this.tile.progress) continue;
            icrafting.sendProgressBarUpdate((Container)this, 0, this.tile.progress);
        }
        ItemStack output = this.craftResult.getStackInSlot(0);
        if (output != this.prevOutput) {
            this.prevOutput = output;
            this.onCraftMatrixChanged((IInventory)this.tile.craftMatrix);
        }
        this.lastProgress = this.tile.progress;
    }

    public void updateProgressBar(int id, int data) {
        switch (id) {
            case 0: {
                this.tile.progress = data;
            }
        }
    }

    public final void onCraftMatrixChanged(IInventory inv) {
        super.onCraftMatrixChanged(inv);
        this.tile.craftMatrix.rebuildCache();
        ItemStack output = this.tile.craftMatrix.getRecipeOutput();
        this.craftResult.setInventorySlotContents(0, output);
    }

    @Override
    public ItemStack slotClick(int i, int j, int modifier, EntityPlayer entityplayer) {
        ItemStack stack = super.slotClick(i, j, modifier, entityplayer);
        this.onCraftMatrixChanged((IInventory)this.tile.craftMatrix);
        return stack;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.tile.isUseableByPlayer(entityplayer);
    }
}

