/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.core.BCLog;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.robots.RobotManager;
import buildcraft.robotics.DockingStationPipe;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.StationIndex;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkEvent;

public class RobotRegistry
extends WorldSavedData
implements IRobotRegistry {
    protected World world;
    protected final HashMap<StationIndex, DockingStation> stations = new HashMap();
    private long nextRobotID = Long.MIN_VALUE;
    private final LongHashMap robotsLoaded = new LongHashMap();
    private final HashSet<EntityRobot> robotsLoadedSet = new HashSet();
    private final HashMap<ResourceId, Long> resourcesTaken = new HashMap();
    private final LongHashMap resourcesTakenByRobot = new LongHashMap();
    private final LongHashMap stationsTakenByRobot = new LongHashMap();

    public RobotRegistry(String id) {
        super(id);
    }

    @Override
    public long getNextRobotId() {
        long result = this.nextRobotID++;
        return result;
    }

    @Override
    public void registerRobot(EntityRobotBase robot) {
        this.markDirty();
        if (robot.getRobotId() == Long.MAX_VALUE) {
            ((EntityRobot)robot).setUniqueRobotId(this.getNextRobotId());
        }
        if (this.robotsLoaded.containsItem(robot.getRobotId())) {
            BCLog.logger.warn("Robot with id %d was not unregistered properly", new Object[]{robot.getRobotId()});
        }
        this.addRobotLoaded((EntityRobot)robot);
    }

    private HashSet<ResourceId> getResourcesTakenByRobot(long robotId) {
        return (HashSet)this.resourcesTakenByRobot.getValueByKey(robotId);
    }

    private HashSet<StationIndex> getStationsTakenByRobot(long robotId) {
        return (HashSet)this.stationsTakenByRobot.getValueByKey(robotId);
    }

    private void addRobotLoaded(EntityRobot robot) {
        this.robotsLoaded.add(robot.getRobotId(), (Object)robot);
        this.robotsLoadedSet.add(robot);
    }

    private void removeRobotLoaded(EntityRobot robot) {
        this.robotsLoaded.remove(robot.getRobotId());
        this.robotsLoadedSet.remove(robot);
    }

    @Override
    public void killRobot(EntityRobotBase robot) {
        this.markDirty();
        this.releaseResources(robot, true);
        this.removeRobotLoaded((EntityRobot)robot);
    }

    @Override
    public void unloadRobot(EntityRobotBase robot) {
        this.markDirty();
        this.releaseResources(robot, false, true);
        this.removeRobotLoaded((EntityRobot)robot);
    }

    @Override
    public EntityRobot getLoadedRobot(long id) {
        if (this.robotsLoaded.containsItem(id)) {
            return (EntityRobot)this.robotsLoaded.getValueByKey(id);
        }
        return null;
    }

    @Override
    public synchronized boolean isTaken(ResourceId resourceId) {
        return this.robotIdTaking(resourceId) != Long.MAX_VALUE;
    }

    @Override
    public synchronized long robotIdTaking(ResourceId resourceId) {
        if (!this.resourcesTaken.containsKey(resourceId)) {
            return Long.MAX_VALUE;
        }
        long robotId = this.resourcesTaken.get(resourceId);
        if (this.robotsLoaded.containsItem(robotId) && !((EntityRobot)this.robotsLoaded.getValueByKey((long)robotId)).isDead) {
            return robotId;
        }
        this.release(resourceId);
        return Long.MAX_VALUE;
    }

    @Override
    public synchronized EntityRobot robotTaking(ResourceId resourceId) {
        long robotId = this.robotIdTaking(resourceId);
        if (robotId == Long.MAX_VALUE || !this.robotsLoaded.containsItem(robotId)) {
            return null;
        }
        return (EntityRobot)this.robotsLoaded.getValueByKey(robotId);
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, EntityRobotBase robot) {
        this.markDirty();
        return this.take(resourceId, robot.getRobotId());
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, long robotId) {
        if (resourceId == null) {
            return false;
        }
        this.markDirty();
        if (!this.resourcesTaken.containsKey(resourceId)) {
            this.resourcesTaken.put(resourceId, robotId);
            if (!this.resourcesTakenByRobot.containsItem(robotId)) {
                this.resourcesTakenByRobot.add(robotId, new HashSet());
            }
            this.getResourcesTakenByRobot(robotId).add(resourceId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void release(ResourceId resourceId) {
        if (resourceId == null) {
            return;
        }
        this.markDirty();
        if (this.resourcesTaken.containsKey(resourceId)) {
            long robotId = this.resourcesTaken.get(resourceId);
            this.getResourcesTakenByRobot(robotId).remove(resourceId);
            this.resourcesTaken.remove(resourceId);
        }
    }

    @Override
    public synchronized void releaseResources(EntityRobotBase robot) {
        this.releaseResources(robot, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll) {
        this.releaseResources(robot, forceAll, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll, boolean resetEntities) {
        this.markDirty();
        if (this.resourcesTakenByRobot.containsItem(robot.getRobotId())) {
            HashSet resourceSet = (HashSet)this.getResourcesTakenByRobot(robot.getRobotId()).clone();
            for (ResourceId id : resourceSet) {
                this.release(id);
            }
            this.resourcesTakenByRobot.remove(robot.getRobotId());
        }
        if (this.stationsTakenByRobot.containsItem(robot.getRobotId())) {
            HashSet stationSet = (HashSet)this.getStationsTakenByRobot(robot.getRobotId()).clone();
            for (StationIndex s : stationSet) {
                DockingStation d = this.stations.get(s);
                if (d == null) continue;
                if (!d.canRelease()) {
                    if (forceAll) {
                        d.unsafeRelease(robot);
                        continue;
                    }
                    if (!resetEntities || d.robotIdTaking() != robot.getRobotId()) continue;
                    d.invalidateRobotTakingEntity();
                    continue;
                }
                d.unsafeRelease(robot);
            }
            if (forceAll) {
                this.stationsTakenByRobot.remove(robot.getRobotId());
            }
        }
    }

    @Override
    public synchronized DockingStation getStation(int x, int y, int z, ForgeDirection side) {
        StationIndex index = new StationIndex(side, x, y, z);
        if (this.stations.containsKey(index)) {
            return this.stations.get(index);
        }
        return null;
    }

    @Override
    public synchronized Collection<DockingStation> getStations() {
        return this.stations.values();
    }

    @Override
    public synchronized void registerStation(DockingStation station) {
        this.markDirty();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            throw new InvalidParameterException("Station " + index + " already registered");
        }
        this.stations.put(index, station);
    }

    @Override
    public synchronized void removeStation(DockingStation station) {
        this.markDirty();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            if (station.robotTaking() != null) {
                if (!station.isMainStation()) {
                    station.robotTaking().undock();
                } else {
                    station.robotTaking().setMainStation(null);
                }
            } else if (station.robotIdTaking() != Long.MAX_VALUE && this.stationsTakenByRobot.containsItem(station.robotIdTaking())) {
                this.getStationsTakenByRobot(station.robotIdTaking()).remove(index);
            }
            this.stations.remove(index);
        }
    }

    @Override
    public synchronized void take(DockingStation station, long robotId) {
        if (!this.stationsTakenByRobot.containsItem(robotId)) {
            this.stationsTakenByRobot.add(robotId, new HashSet());
        }
        this.getStationsTakenByRobot(robotId).add(new StationIndex(station));
    }

    @Override
    public synchronized void release(DockingStation station, long robotId) {
        if (this.stationsTakenByRobot.containsItem(robotId)) {
            this.getStationsTakenByRobot(robotId).remove(new StationIndex(station));
        }
    }

    @Override
    public synchronized void writeToNBT(NBTTagCompound nbt) {
        nbt.setLong("nextRobotID", this.nextRobotID);
        NBTTagList resourceList = new NBTTagList();
        for (Map.Entry<ResourceId, Long> e : this.resourcesTaken.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            NBTTagCompound resourceId = new NBTTagCompound();
            e.getKey().writeToNBT(resourceId);
            cpt.setTag("resourceId", (NBTBase)resourceId);
            cpt.setLong("robotId", e.getValue().longValue());
            resourceList.appendTag((NBTBase)cpt);
        }
        nbt.setTag("resourceList", (NBTBase)resourceList);
        NBTTagList stationList = new NBTTagList();
        for (Map.Entry<StationIndex, DockingStation> e : this.stations.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            e.getValue().writeToNBT(cpt);
            cpt.setString("stationType", RobotManager.getDockingStationName(e.getValue().getClass()));
            stationList.appendTag((NBTBase)cpt);
        }
        nbt.setTag("stationList", (NBTBase)stationList);
    }

    @Override
    public synchronized void readFromNBT(NBTTagCompound nbt) {
        this.nextRobotID = nbt.getLong("nextRobotID");
        NBTTagList resourceList = nbt.getTagList("resourceList", 10);
        for (int i = 0; i < resourceList.tagCount(); ++i) {
            NBTTagCompound cpt = resourceList.getCompoundTagAt(i);
            ResourceId resourceId = ResourceId.load(cpt.getCompoundTag("resourceId"));
            long robotId = cpt.getLong("robotId");
            this.take(resourceId, robotId);
        }
        NBTTagList stationList = nbt.getTagList("stationList", 10);
        for (int i = 0; i < stationList.tagCount(); ++i) {
            Class cls;
            NBTTagCompound cpt = stationList.getCompoundTagAt(i);
            if (!cpt.hasKey("stationType")) {
                cls = DockingStationPipe.class;
            } else {
                cls = RobotManager.getDockingStationByName(cpt.getString("stationType"));
                if (cls == null) {
                    BCLog.logger.error("Could not load docking station of type " + nbt.getString("stationType"));
                    continue;
                }
            }
            try {
                DockingStation station = (DockingStation)cls.newInstance();
                station.readFromNBT(cpt);
                this.registerStation(station);
                if (station.linkedId() == Long.MAX_VALUE) continue;
                this.take(station, station.linkedId());
                continue;
            }
            catch (Exception e) {
                BCLog.logger.error("Could not load docking station", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        if (e.world == this.world) {
            for (EntityRobot robot : new ArrayList<EntityRobot>(this.robotsLoadedSet)) {
                if (e.world.loadedEntityList.contains(robot)) continue;
                robot.onChunkUnload();
            }
            for (DockingStation station : new ArrayList<DockingStation>(this.stations.values())) {
                if (this.world.blockExists(station.x(), station.y(), station.z())) continue;
                station.onChunkUnload();
            }
        }
    }

    @Override
    public void registryMarkDirty() {
        this.markDirty();
    }
}

