/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftRobotics;
import buildcraft.api.core.IZone;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.items.IMapLocation;
import buildcraft.api.items.INamedItem;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.robotics.ZonePlan;
import buildcraft.robotics.gui.ContainerZonePlan;
import buildcraft.robotics.map.MapWorld;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class TileZonePlan
extends TileBuildCraft
implements IInventory {
    public static final int RESOLUTION = 2048;
    public static final int CRAFT_TIME = 120;
    private static final int PREVIEW_BLOCKS_PER_PIXEL = 10;
    private static int RESOLUTION_CHUNKS = 128;
    public int chunkStartX;
    public int chunkStartZ;
    public short progress = 0;
    public String mapName = "";
    private final byte[] previewColors = new byte[80];
    private final SimpleInventory inv = new SimpleInventory(3, "inv", 64);
    private final SafeTimeTracker previewRecalcTimer = new SafeTimeTracker(100L);
    private boolean previewColorsPushed = false;
    private ZonePlan[] selectedAreas = new ZonePlan[16];
    private int currentSelectedArea = 0;

    public byte[] getPreviewTexture(boolean force) {
        if (!this.previewColorsPushed || force) {
            this.previewColorsPushed = true;
            return this.previewColors;
        }
        return null;
    }

    @Override
    public void initialize() {
        super.initialize();
        int cx = this.xCoord >> 4;
        int cz = this.zCoord >> 4;
        this.chunkStartX = cx - RESOLUTION_CHUNKS / 2;
        this.chunkStartZ = cz - RESOLUTION_CHUNKS / 2;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.previewRecalcTimer.markTimeIfDelay(this.worldObj)) {
            this.recalculatePreview();
        }
        if (this.inv.getStackInSlot(0) != null && this.inv.getStackInSlot(1) == null && this.inv.getStackInSlot(0).getItem() instanceof ItemMapLocation) {
            if (this.progress < 120) {
                this.progress = (short)(this.progress + 1);
                if (this.worldObj.getTotalWorldTime() % 5L == 0L) {
                    this.sendNetworkUpdate();
                }
            } else {
                ItemStack stack = this.inv.decrStackSize(0, 1);
                if (this.selectedAreas[this.currentSelectedArea] != null) {
                    ItemMapLocation.setZone(stack, this.selectedAreas[this.currentSelectedArea]);
                    ((INamedItem)stack.getItem()).setName(stack, this.mapName);
                }
                this.inv.setInventorySlotContents(1, stack);
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.sendNetworkUpdate();
        }
    }

    private void recalculatePreview() {
        byte[] newPreviewColors = new byte[80];
        MapWorld mw = BuildCraftRobotics.manager.getWorld(this.worldObj);
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 10; ++x) {
                int tx = x * 10 - 50 + 5;
                int ty = y * 10 - 40 + 5;
                newPreviewColors[y * 10 + x] = (byte)mw.getColor(this.xCoord - this.xCoord % 10 + tx, this.zCoord - this.zCoord % 10 + ty);
            }
        }
        if (!Arrays.equals(this.previewColors, newPreviewColors)) {
            System.arraycopy(newPreviewColors, 0, this.previewColors, 0, 80);
            this.sendNetworkUpdate();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.setString("name", this.mapName);
        NBTTagCompound invNBT = new NBTTagCompound();
        this.inv.writeToNBT(invNBT);
        nbt.setTag("inv", (NBTBase)invNBT);
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (this.selectedAreas[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            this.selectedAreas[i].writeToNBT(subNBT);
            nbt.setTag("selectedArea[" + i + "]", (NBTBase)subNBT);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.mapName = nbt.getString("name");
        if (this.mapName == null) {
            this.mapName = "";
        }
        this.inv.readFromNBT(nbt.getCompoundTag("inv"));
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (!nbt.hasKey("selectedArea[" + i + "]")) continue;
            this.selectedAreas[i] = new ZonePlan();
            this.selectedAreas[i].readFromNBT(nbt.getCompoundTag("selectedArea[" + i + "]"));
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeShort((int)this.progress);
        NetworkUtils.writeUTF(stream, this.mapName);
        stream.writeBytes(this.previewColors, 0, 80);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.progress = stream.readShort();
        this.mapName = NetworkUtils.readUTF(stream);
        stream.readBytes(this.previewColors, 0, 80);
        this.previewColorsPushed = false;
    }

    private void importMap(ItemStack stack) {
        IZone zone;
        if (stack != null && stack.getItem() instanceof IMapLocation && (zone = ((IMapLocation)stack.getItem()).getZone(stack)) != null && zone instanceof ZonePlan) {
            this.selectedAreas[this.currentSelectedArea] = (ZonePlan)zone;
            for (EntityPlayer e : MinecraftServer.getServer().getConfigurationManager().playerEntityList) {
                if (e.openContainer == null || !(e.openContainer instanceof ContainerZonePlan) || ((ContainerZonePlan)e.openContainer).getTile() != this) continue;
                PacketCommand p = new PacketCommand(e.openContainer, "areaLoaded", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        ((ZonePlan)zone).writeData(data);
                    }
                });
                BuildCraftCore.instance.sendToPlayer(e, p);
            }
        }
    }

    public ZonePlan selectArea(int index) {
        if (this.selectedAreas[index] == null) {
            this.selectedAreas[index] = new ZonePlan();
        }
        this.currentSelectedArea = index;
        return this.selectedAreas[index];
    }

    public void setArea(int index, ZonePlan area) {
        this.selectedAreas[index] = area;
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.inv.getStackInSlot(slotId);
    }

    public ItemStack decrStackSize(int slotId, int count) {
        return this.inv.decrStackSize(slotId, count);
    }

    public ItemStack getStackInSlotOnClosing(int slotId) {
        return this.inv.getStackInSlotOnClosing(slotId);
    }

    public void setInventorySlotContents(int slotId, ItemStack itemstack) {
        this.inv.setInventorySlotContents(slotId, itemstack);
        if (!this.worldObj.isRemote && slotId == 2) {
            this.importMap(itemstack);
        }
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return this.inv.hasCustomInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.inv.isUseableByPlayer(entityplayer);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.inv.isItemValidForSlot(i, itemstack);
    }
}

