/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.robotics.ai.AIRobotGotoStationAndUnload;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;

public class AIRobotDisposeItems
extends AIRobot {
    public AIRobotDisposeItems(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationAndUnload) {
            if (ai.success()) {
                if (this.robot.containsItems()) {
                    this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot));
                } else {
                    this.terminate();
                }
            } else {
                for (IInvSlot slot : InventoryIterator.getIterable(this.robot)) {
                    if (slot.getStackInSlot() == null) continue;
                    EntityItem entity = new EntityItem(this.robot.worldObj, this.robot.posX, this.robot.posY, this.robot.posZ, slot.getStackInSlot());
                    this.robot.worldObj.spawnEntityInWorld((Entity)entity);
                    slot.setStackInSlot(null);
                }
                this.terminate();
            }
        }
    }
}

