/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.TransactorSimple;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.boards.BoardRobotPicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotFetchItem
extends AIRobot {
    private EntityItem target;
    private float maxRange;
    private IStackFilter stackFilter;
    private int pickTime = -1;
    private IZone zone;

    public AIRobotFetchItem(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotFetchItem(EntityRobotBase iRobot, float iMaxRange, IStackFilter iStackFilter, IZone iZone) {
        this(iRobot);
        this.maxRange = iMaxRange;
        this.stackFilter = iStackFilter;
        this.zone = iZone;
    }

    @Override
    public void preempt(AIRobot ai) {
        if (this.target != null && this.target.isDead) {
            this.terminate();
        }
    }

    @Override
    public void update() {
        if (this.target == null) {
            this.scanForItem();
        } else {
            ++this.pickTime;
            if (this.pickTime > 5) {
                TransactorSimple inventoryInsert = new TransactorSimple(this.robot);
                this.target.getEntityItem().stackSize -= inventoryInsert.inject(this.target.getEntityItem(), ForgeDirection.UNKNOWN, true);
                if (this.target.getEntityItem().stackSize <= 0) {
                    this.target.setDead();
                }
                this.terminate();
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            if (this.target == null) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            if (!ai.success()) {
                this.robot.unreachableEntityDetected((Entity)this.target);
                this.setSuccess(false);
                this.terminate();
            }
        }
    }

    @Override
    public void end() {
        if (this.target != null) {
            BoardRobotPicker.targettedItems.remove(this.target.getEntityId());
        }
    }

    private void scanForItem() {
        double previousDistance = Double.MAX_VALUE;
        TransactorSimple inventoryInsert = new TransactorSimple(this.robot);
        for (Object o : this.robot.worldObj.loadedEntityList) {
            EntityItem item;
            double maxDistance;
            double dz;
            double dy;
            double dx;
            double sqrDistance;
            Entity e = (Entity)o;
            if (e.isDead || !(e instanceof EntityItem) || BoardRobotPicker.targettedItems.contains(e.getEntityId()) || this.robot.isKnownUnreachable(e) || this.zone != null && !this.zone.contains(e.posX, e.posY, e.posZ) || (sqrDistance = (dx = e.posX - this.robot.posX) * dx + (dy = e.posY - this.robot.posY) * dy + (dz = e.posZ - this.robot.posZ) * dz) >= (maxDistance = (double)(this.maxRange * this.maxRange)) || this.stackFilter != null && !this.stackFilter.matches(((EntityItem)e).getEntityItem()) || inventoryInsert.inject((item = (EntityItem)e).getEntityItem(), ForgeDirection.UNKNOWN, false) <= 0) continue;
            if (this.target == null) {
                previousDistance = sqrDistance;
                this.target = item;
                continue;
            }
            if (!(sqrDistance < previousDistance)) continue;
            previousDistance = sqrDistance;
            this.target = item;
        }
        if (this.target != null) {
            BoardRobotPicker.targettedItems.add(this.target.getEntityId());
            if (Math.floor(this.target.posX) != Math.floor(this.robot.posX) || Math.floor(this.target.posY) != Math.floor(this.robot.posY) || Math.floor(this.target.posZ) != Math.floor(this.robot.posZ)) {
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, (int)Math.floor(this.target.posX), (int)Math.floor(this.target.posY), (int)Math.floor(this.target.posZ)));
            }
        } else {
            this.setSuccess(false);
            this.terminate();
        }
    }

    @Override
    public int getEnergyCost() {
        return 15;
    }
}

