/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.crops.CropManager;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;

public class AIRobotPlant
extends AIRobot {
    private BlockIndex blockFound;
    private int delay = 0;

    public AIRobotPlant(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotPlant(EntityRobotBase iRobot, BlockIndex iBlockFound) {
        this(iRobot);
        this.blockFound = iBlockFound;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockFound.x, this.blockFound.y, this.blockFound.z);
        this.robot.setItemActive(true);
    }

    @Override
    public void update() {
        if (this.blockFound == null) {
            this.setSuccess(false);
            this.terminate();
        }
        if (this.delay++ > 40) {
            EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.worldObj).get();
            if (!CropManager.plantCrop(this.robot.worldObj, player, this.robot.getHeldItem(), this.blockFound.x, this.blockFound.y, this.blockFound.z)) {
                this.setSuccess(false);
            }
            if (this.robot.getHeldItem().stackSize > 0) {
                BlockUtils.dropItem((WorldServer)this.robot.worldObj, MathHelper.floor_double((double)this.robot.posX), MathHelper.floor_double((double)this.robot.posY), MathHelper.floor_double((double)this.robot.posZ), 6000, this.robot.getHeldItem());
            }
            this.robot.setItemInUse(null);
            this.terminate();
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.setTag("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("blockFound")) {
            this.blockFound = new BlockIndex(nbt.getCompoundTag("blockFound"));
        }
    }
}

