/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.IBlockFilter;
import net.minecraft.util.MathHelper;

public class AIRobotSearchRandomGroundBlock
extends AIRobot {
    private static final int MAX_ATTEMPTS = 4096;
    public BlockIndex blockFound;
    private int range;
    private IBlockFilter filter;
    private IZone zone;
    private int attempts = 0;

    public AIRobotSearchRandomGroundBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchRandomGroundBlock(EntityRobotBase iRobot, int iRange, IBlockFilter iFilter, IZone iZone) {
        this(iRobot);
        this.range = iRange;
        this.filter = iFilter;
        this.zone = iZone;
    }

    @Override
    public void update() {
        int z;
        int x;
        if (this.filter == null) {
            this.terminate();
        }
        ++this.attempts;
        if (this.attempts > 4096) {
            this.terminate();
        }
        if (this.zone == null) {
            double r = this.robot.worldObj.rand.nextFloat() * (float)this.range;
            float a = this.robot.worldObj.rand.nextFloat() * 2.0f * (float)Math.PI;
            x = (int)((double)MathHelper.cos((float)a) * r + Math.floor(this.robot.posX));
            z = (int)((double)MathHelper.sin((float)a) * r + Math.floor(this.robot.posZ));
        } else {
            BlockIndex b = this.zone.getRandomBlockIndex(this.robot.worldObj.rand);
            x = b.x;
            z = b.z;
        }
        for (int y = this.robot.worldObj.getHeight(); y >= 0; --y) {
            if (this.filter.matches(this.robot.worldObj, x, y, z)) {
                this.blockFound = new BlockIndex(x, y, z);
                this.terminate();
                return;
            }
            if (this.robot.worldObj.isAirBlock(x, y, z)) continue;
            return;
        }
    }

    @Override
    public boolean success() {
        return this.blockFound != null;
    }

    @Override
    public int getEnergyCost() {
        return 2;
    }
}

