/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotGoto;
import net.minecraft.nbt.NBTTagCompound;

public class AIRobotStraightMoveTo
extends AIRobotGoto {
    private double prevDistance = Double.MAX_VALUE;
    private float x;
    private float y;
    private float z;

    public AIRobotStraightMoveTo(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotStraightMoveTo(EntityRobotBase iRobot, float ix, float iy, float iz) {
        this(iRobot);
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.robot.aimItemAt((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
    }

    @Override
    public void start() {
        this.robot.undock();
        this.setDestination(this.robot, this.x, this.y, this.z);
    }

    @Override
    public void update() {
        double distance = this.robot.getDistance(this.nextX, this.nextY, this.nextZ);
        if (distance < this.prevDistance) {
            this.prevDistance = distance;
        } else {
            this.robot.motionX = 0.0;
            this.robot.motionY = 0.0;
            this.robot.motionZ = 0.0;
            this.robot.posX = this.x;
            this.robot.posY = this.y;
            this.robot.posZ = this.z;
            this.terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.setFloat("x", this.x);
        nbt.setFloat("y", this.y);
        nbt.setFloat("z", this.z);
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("x")) {
            this.x = nbt.getFloat("x");
            this.y = nbt.getFloat("y");
            this.z = nbt.getFloat("z");
        }
    }
}

