/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.inventory.filters.ArrayStackFilter;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndLoad;
import buildcraft.robotics.ai.AIRobotSearchRandomGroundBlock;
import buildcraft.robotics.boards.BCBoardNBT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BoardRobotBomber
extends RedstoneBoardRobot {
    private static final IStackFilter TNT_FILTER = new ArrayStackFilter(new ItemStack(Blocks.tnt));
    private int flyingHeight = 20;

    public BoardRobotBomber(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("bomber");
    }

    @Override
    public final void update() {
        boolean containItems = false;
        for (int i = 0; i < this.robot.getSizeInventory(); ++i) {
            if (this.robot.getStackInSlot(i) == null) continue;
            containItems = true;
        }
        if (!containItems) {
            this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, TNT_FILTER, -1));
        } else {
            this.startDelegateAI(new AIRobotSearchRandomGroundBlock(this.robot, 100, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    return y < world.getHeight() - BoardRobotBomber.this.flyingHeight && !world.isAirBlock(x, y, z);
                }
            }, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationAndLoad) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotSearchRandomGroundBlock) {
            if (ai.success()) {
                AIRobotSearchRandomGroundBlock aiFind = (AIRobotSearchRandomGroundBlock)ai;
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, aiFind.blockFound.x, aiFind.blockFound.y + this.flyingHeight, aiFind.blockFound.z));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            if (ai.success()) {
                ITransactor t = Transactor.getTransactorFor((Object)this.robot);
                ItemStack stack = t.remove(TNT_FILTER, ForgeDirection.UNKNOWN, true);
                if (stack != null && stack.stackSize > 0) {
                    EntityTNTPrimed tnt = new EntityTNTPrimed(this.robot.worldObj, this.robot.posX + 0.25, this.robot.posY - 1.0, this.robot.posZ + 0.25, (EntityLivingBase)this.robot);
                    tnt.fuse = 37;
                    this.robot.worldObj.spawnEntityInWorld((Entity)tnt);
                    this.robot.worldObj.playSoundAtEntity((Entity)tnt, "game.tnt.primed", 1.0f, 1.0f);
                }
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }
}

