/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.statements.StatementSlot;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotSearchAndGotoBlock;
import buildcraft.robotics.statements.ActionRobotFilter;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class BoardRobotGenericSearchBlock
extends RedstoneBoardRobot {
    private BlockIndex blockFound;
    private ArrayList<Block> blockFilter = new ArrayList();
    private ArrayList<Integer> metaFilter = new ArrayList();

    public BoardRobotGenericSearchBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public abstract boolean isExpectedBlock(World var1, int var2, int var3, int var4);

    @Override
    public void update() {
        this.updateFilter();
        this.startDelegateAI(new AIRobotSearchAndGotoBlock(this.robot, false, new IBlockFilter(){

            @Override
            public boolean matches(World world, int x, int y, int z) {
                if (BoardRobotGenericSearchBlock.this.isExpectedBlock(world, x, y, z) && !BoardRobotGenericSearchBlock.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z))) {
                    return BoardRobotGenericSearchBlock.this.matchesGateFilter(world, x, y, z);
                }
                return false;
            }
        }));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoBlock) {
            if (ai.success()) {
                this.blockFound = ((AIRobotSearchAndGotoBlock)ai).getBlockFound();
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }

    @Override
    public void end() {
        this.releaseBlockFound(true);
    }

    protected BlockIndex blockFound() {
        return this.blockFound;
    }

    protected void releaseBlockFound(boolean success) {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    public final void updateFilter() {
        this.blockFilter.clear();
        this.metaFilter.clear();
        for (StatementSlot slot : this.robot.getLinkedStation().getActiveActions()) {
            if (!(slot.statement instanceof ActionRobotFilter)) continue;
            for (IStatementParameter p : slot.parameters) {
                StatementParameterItemStack param;
                ItemStack stack;
                if (p == null || !(p instanceof StatementParameterItemStack) || (stack = (param = (StatementParameterItemStack)p).getItemStack()) == null || !(stack.getItem() instanceof ItemBlock)) continue;
                this.blockFilter.add(((ItemBlock)stack.getItem()).field_150939_a);
                this.metaFilter.add(stack.getItemDamage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchesGateFilter(World world, int x, int y, int z) {
        int meta;
        Block block;
        if (this.blockFilter.size() == 0) {
            return true;
        }
        World world2 = world;
        synchronized (world2) {
            block = world.getBlock(x, y, z);
            meta = world.getBlockMetadata(x, y, z);
        }
        for (int i = 0; i < this.blockFilter.size(); ++i) {
            if (this.blockFilter.get(i) != block || this.metaFilter.get(i) != meta) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.setTag("indexStored", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("indexStored")) {
            this.blockFound = new BlockIndex(nbt.getCompoundTag("indexStored"));
        }
    }
}

