/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IWorldProperty;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.inventory.filters.IFluidFilter;
import buildcraft.core.lib.inventory.filters.PassThroughFluidFilter;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndUnloadFluids;
import buildcraft.robotics.ai.AIRobotPumpBlock;
import buildcraft.robotics.ai.AIRobotSearchAndGotoBlock;
import buildcraft.robotics.boards.BCBoardNBT;
import buildcraft.robotics.statements.ActionRobotFilter;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BoardRobotPump
extends RedstoneBoardRobot {
    private BlockIndex blockFound;
    private IFluidFilter fluidFilter = null;

    public BoardRobotPump(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("pump");
    }

    @Override
    public void update() {
        final IWorldProperty isFluidSource = BuildCraftAPI.getWorldProperty("fluidSource");
        FluidStack tank = this.robot.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
        if (tank != null && tank.amount > 0) {
            this.startDelegateAI(new AIRobotGotoStationAndUnloadFluids(this.robot));
        } else {
            this.updateFilter();
            this.startDelegateAI(new AIRobotSearchAndGotoBlock(this.robot, false, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    if (isFluidSource.get(world, x, y, z) && !BoardRobotPump.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z))) {
                        return BoardRobotPump.this.matchesGateFilter(world, x, y, z);
                    }
                    return false;
                }
            }));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoBlock) {
            if (ai.success()) {
                this.blockFound = ((AIRobotSearchAndGotoBlock)ai).getBlockFound();
                this.startDelegateAI(new AIRobotPumpBlock(this.robot, this.blockFound));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotPumpBlock) {
            this.releaseBlockFound();
        } else if (ai instanceof AIRobotGotoStationAndUnloadFluids && !ai.success()) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
        }
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    public void updateFilter() {
        this.fluidFilter = ActionRobotFilter.getGateFluidFilter(this.robot.getLinkedStation());
        if (this.fluidFilter instanceof PassThroughFluidFilter) {
            this.fluidFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesGateFilter(World world, int x, int y, int z) {
        Block block;
        if (this.fluidFilter == null) {
            return true;
        }
        World world2 = world;
        synchronized (world2) {
            block = world.getBlock(x, y, z);
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        return this.fluidFilter.matches(fluid);
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.setTag("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("blockFound")) {
            this.blockFound = new BlockIndex(nbt.getCompoundTag("blockFound"));
        }
    }
}

