/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.robotics.TileRequester;
import buildcraft.robotics.gui.GuiRequester;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerRequester
extends BuildCraftContainer
implements ICommandReceiver {
    public GuiRequester gui;
    public ItemStack[] requests = new ItemStack[20];
    private TileRequester requester;

    public ContainerRequester(IInventory playerInventory, TileRequester iRequester) {
        super(iRequester.getSizeInventory());
        this.requester = iRequester;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.addSlotToContainer(new Slot((IInventory)iRequester, x * 5 + y, 117 + x * 18, 7 + y * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlotToContainer(new Slot(playerInventory, k1 + l * 9 + 9, 19 + k1 * 18, 101 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot(playerInventory, i1, 19 + i1 * 18, 159));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    public void getRequestList() {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "getRequestList", null));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "getRequestList".equals(command)) {
            final ItemStack[] stacks = new ItemStack[20];
            for (int i = 0; i < 20; ++i) {
                stacks[i] = this.requester.getRequestTemplate(i);
            }
            BuildCraftCore.instance.sendToPlayer((EntityPlayer)sender, new PacketCommand(this, "receiveRequestList", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    for (ItemStack s : stacks) {
                        NetworkUtils.writeStack(data, s);
                    }
                }
            }));
        } else if (side.isClient() && "receiveRequestList".equals(command)) {
            this.requests = new ItemStack[20];
            for (int i = 0; i < 20; ++i) {
                this.requests[i] = NetworkUtils.readStack(stream);
            }
        }
    }
}

