/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.EnumColor;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.buttons.GuiBetterButton;
import buildcraft.core.lib.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.render.DynamicTextureBC;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.robotics.TileZonePlan;
import buildcraft.robotics.ZonePlan;
import buildcraft.robotics.gui.ContainerZonePlan;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiZonePlan
extends GuiAdvancedInterface {
    public static final int WINDOWED_MAP_WIDTH = 213;
    public static final int WINDOWED_MAP_HEIGHT = 100;
    private static final ResourceLocation TMP_TEXTURE = new ResourceLocation("buildcraftrobotics:textures/gui/zone_planner_gui.png");
    private int mapWidth = 213;
    private int mapHeight = 100;
    private TileZonePlan zonePlan;
    private DynamicTextureBC newSelection;
    private int selX1 = 0;
    private int selX2 = 0;
    private int selY1 = 0;
    private int selY2 = 0;
    private boolean inSelection = false;
    private DynamicTextureBC currentSelection;
    private int mapXMin = 0;
    private int mapYMin = 0;
    private float blocksPerPixel = 1.0f;
    private int cx;
    private int cz;
    private AreaSlot colorSelected = null;
    private float alpha = 0.8f;
    private GuiBetterButton tool;
    private GuiBetterButton fsButton;
    private List<GuiBetterButton> savedButtonList;
    private GuiTextField textField;

    public GuiZonePlan(IInventory inventory, TileZonePlan iZonePlan) {
        super(new ContainerZonePlan(inventory, iZonePlan), inventory, TMP_TEXTURE);
        this.getContainer().gui = this;
        this.xSize = 256;
        this.ySize = 228;
        this.zonePlan = iZonePlan;
        this.getContainer().mapTexture = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.currentSelection = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.newSelection = new DynamicTextureBC(1, 1);
        this.getContainer().currentAreaSelection = new ZonePlan();
        this.cx = this.zonePlan.xCoord;
        this.cz = this.zonePlan.zCoord;
        this.resetNullSlots(16);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots.set(i * 4 + j, new AreaSlot(this, 8 + 18 * i, 146 + 18 * j, EnumColor.values()[i * 4 + j]));
            }
        }
        this.colorSelected = (AreaSlot)this.slots.get(0);
        this.newSelection.setColor(0, 0, this.colorSelected.color.getDarkHex(), this.alpha);
        this.uploadMap();
        this.getContainer().loadArea(this.colorSelected.color.ordinal());
    }

    public void initGui() {
        super.initGui();
        this.tool = new GuiBetterButton(0, this.guiLeft + 27, this.guiTop + 111, 15, StandardButtonTextureSets.SMALL_BUTTON, "+");
        this.tool.setToolTip(new ToolTip(new ToolTipLine(StringUtils.localize("tip.tool.add"))));
        this.buttonList.add(this.tool);
        this.fsButton = new GuiBetterButton(1, this.guiLeft + 44, this.guiTop + 111, 20, StandardButtonTextureSets.SMALL_BUTTON, "FS");
        this.fsButton.setToolTip(new ToolTip(new ToolTipLine(StringUtils.localize("tip.tool.fullscreen"))));
        this.buttonList.add(this.fsButton);
        this.savedButtonList = this.buttonList;
        this.textField = new GuiTextField(this.fontRendererObj, 28, 129, 156, 12);
        this.textField.setMaxStringLength(32);
        this.textField.setText(this.zonePlan.mapName);
        this.textField.setFocused(true);
    }

    private void uploadMap() {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this.getContainer(), "computeMap", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeInt(GuiZonePlan.this.cx);
                data.writeInt(GuiZonePlan.this.cz);
                data.writeShort(GuiZonePlan.this.getContainer().mapTexture.width);
                data.writeShort(GuiZonePlan.this.getContainer().mapTexture.height);
                data.writeFloat(GuiZonePlan.this.blocksPerPixel);
            }
        }));
    }

    private boolean isFullscreen() {
        return this.getContainer().mapTexture.height > 100;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(f, x, y);
        this.mapXMin = this.getContainer().mapTexture.width <= 213 ? this.guiLeft + 8 + (213 - this.getContainer().mapTexture.width) / 2 : (this.width - this.getContainer().mapTexture.width) / 2;
        this.mapYMin = this.getContainer().mapTexture.height <= 100 ? this.guiTop + 9 + (100 - this.getContainer().mapTexture.height) / 2 : (this.height - this.getContainer().mapTexture.height) / 2;
        this.getContainer().mapTexture.draw(this.mapXMin, this.mapYMin, this.zLevel);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        this.currentSelection.draw(this.mapXMin, this.mapYMin, this.zLevel);
        GL11.glPopAttrib();
        GL11.glDisable((int)3042);
        this.newSelection.updateTexture();
        if (this.inSelection && this.selX2 != 0) {
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            int x1 = this.selX1 < this.selX2 ? this.selX1 : this.selX2;
            int x2 = this.selX1 < this.selX2 ? this.selX2 : this.selX1;
            int y1 = this.selY1 < this.selY2 ? this.selY1 : this.selY2;
            int y2 = this.selY1 < this.selY2 ? this.selY2 : this.selY1;
            this.drawTexturedModalRect(x1, y1, 0, 0, x2 - x1 + 1, y2 - y1 + 1);
            GL11.glPopAttrib();
            GL11.glDisable((int)3042);
        }
        if (!this.isFullscreen()) {
            this.drawBackgroundSlots(x, y);
            this.bindTexture(this.texture);
            GL11.glEnable((int)3008);
            this.drawTexturedModalRect(this.guiLeft + this.colorSelected.x, this.guiTop + this.colorSelected.y, 0, 228, 16, 16);
            this.drawTexturedModalRect(this.guiLeft + 236, this.guiTop + 27, 16, 228, 8, (int)((float)this.zonePlan.progress / 120.0f * 27.0f));
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        if (!this.isFullscreen()) {
            this.textField.drawTextBox();
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean clickOnMap;
        int blocksX = Math.round((float)(mouseX - this.mapXMin) * this.blocksPerPixel);
        int blocksZ = Math.round((float)(mouseY - this.mapYMin) * this.blocksPerPixel);
        int blockStartX = Math.round((float)this.cx - (float)this.mapWidth * this.blocksPerPixel / 2.0f);
        int blockStartZ = Math.round((float)this.cz - (float)this.mapHeight * this.blocksPerPixel / 2.0f);
        boolean bl = clickOnMap = mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height;
        if (clickOnMap) {
            if (mouseButton == 1) {
                this.cx = blockStartX + blocksX;
                this.cz = blockStartZ + blocksZ;
                this.uploadMap();
                this.refreshSelectedArea();
                return;
            }
            this.inSelection = true;
            this.selX1 = mouseX;
            this.selY1 = mouseY;
            this.selX2 = 0;
            this.selY2 = 0;
            return;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.textField.mouseClicked(mouseX - this.guiLeft, mouseY - this.guiTop, mouseButton);
        AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
        if (slot instanceof AreaSlot) {
            this.colorSelected = (AreaSlot)slot;
            this.newSelection.setColor(0, 0, this.colorSelected.color.getDarkHex(), this.alpha);
            this.getContainer().loadArea(this.colorSelected.color.ordinal());
        }
    }

    @Override
    protected void mouseClickMove(int mouseX, int mouseY, int lastButtonBlicked, long time) {
        super.mouseClickMove(mouseX, mouseY, lastButtonBlicked, time);
        if (this.inSelection && mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height) {
            this.selX2 = mouseX;
            this.selY2 = mouseY;
        }
    }

    @Override
    protected void mouseMovedOrUp(int mouseX, int mouseY, int eventType) {
        super.mouseMovedOrUp(mouseX, mouseY, eventType);
        if (eventType != -1 && this.inSelection) {
            boolean val = this.tool.displayString.equals("+");
            int blockStartX = Math.round((float)this.cx - (float)this.mapWidth * this.blocksPerPixel / 2.0f);
            int blockStartZ = Math.round((float)this.cz - (float)this.mapHeight * this.blocksPerPixel / 2.0f);
            int x1 = this.selX1 < this.selX2 ? this.selX1 : this.selX2;
            int x2 = this.selX1 < this.selX2 ? this.selX2 : this.selX1;
            int y1 = this.selY1 < this.selY2 ? this.selY1 : this.selY2;
            int y2 = this.selY1 < this.selY2 ? this.selY2 : this.selY1;
            int lengthX = Math.round((float)(x2 - x1) * this.blocksPerPixel);
            int lengthY = Math.round((float)(y2 - y1) * this.blocksPerPixel);
            for (int i = 0; i <= lengthX; ++i) {
                for (int j = 0; j <= lengthY; ++j) {
                    int x = Math.round((float)blockStartX + (float)(x1 - this.mapXMin) * this.blocksPerPixel) + i;
                    int z = Math.round((float)blockStartZ + (float)(y1 - this.mapYMin) * this.blocksPerPixel) + j;
                    this.getContainer().currentAreaSelection.set(x, z, val);
                }
            }
            this.inSelection = false;
            this.getContainer().saveArea(this.colorSelected.color.ordinal());
            this.refreshSelectedArea();
        }
    }

    private void toFullscreen() {
        if (this.isFullscreen()) {
            return;
        }
        if (this.blocksPerPixel > 4.0f) {
            this.blocksPerPixel = 4.0f;
        }
        this.mapWidth = this.mc.displayWidth;
        this.mapHeight = this.mc.displayHeight;
        this.getContainer().mapTexture = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.currentSelection = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        for (Slot s : this.container.inventorySlots) {
            s.xDisplayPosition += 0x100000;
            s.yDisplayPosition += 0x100000;
        }
        this.uploadMap();
        this.refreshSelectedArea();
        this.buttonList = new LinkedList();
    }

    private void toWindowed() {
        if (!this.isFullscreen()) {
            return;
        }
        this.mapWidth = 213;
        this.mapHeight = 100;
        this.getContainer().mapTexture = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.currentSelection = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        for (Slot s : this.container.inventorySlots) {
            s.xDisplayPosition -= 0x100000;
            s.yDisplayPosition -= 0x100000;
        }
        this.uploadMap();
        this.refreshSelectedArea();
        this.buttonList = this.savedButtonList;
    }

    private boolean incBlocksPerPixel() {
        if (this.blocksPerPixel > 0.125f) {
            this.blocksPerPixel = this.blocksPerPixel <= 1.0f ? (this.blocksPerPixel /= 2.0f) : (this.blocksPerPixel -= 1.0f);
            return true;
        }
        return false;
    }

    private boolean decBlocksPerPixel() {
        if (this.isFullscreen() && this.blocksPerPixel < 4.0f || !this.isFullscreen() && this.blocksPerPixel < 8.0f) {
            this.blocksPerPixel = this.blocksPerPixel >= 1.0f ? (this.blocksPerPixel += 1.0f) : (this.blocksPerPixel *= 2.0f);
            return true;
        }
        return false;
    }

    protected void keyTyped(char carac, int val) {
        if (!this.isFullscreen() && this.textField.isFocused()) {
            if (carac == '\r' || carac == '\u001b') {
                this.textField.setFocused(false);
            } else {
                this.textField.textboxKeyTyped(carac, val);
                final String text = this.textField.getText();
                BuildCraftCore.instance.sendToServer(new PacketCommand(this.getContainer(), "setName", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        NetworkUtils.writeUTF(data, text);
                    }
                }));
            }
            return;
        }
        if (val == 63) {
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == '+' && this.incBlocksPerPixel()) {
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == '-' && this.decBlocksPerPixel()) {
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == 'm' || carac == '\u001b' && this.isFullscreen()) {
            this.toWindowed();
        } else if (carac == 'M') {
            this.toFullscreen();
        } else {
            super.keyTyped(carac, val);
        }
    }

    public void refreshSelectedArea() {
        int color = this.colorSelected.color.getDarkHex();
        int rAdd = color >> 16 & 0xFF;
        int gAdd = color >> 8 & 0xFF;
        int bAdd = color & 0xFF;
        for (int i = 0; i < this.currentSelection.width; ++i) {
            for (int j = 0; j < this.currentSelection.height; ++j) {
                int blockStartX = Math.round((float)this.cx - (float)this.mapWidth * this.blocksPerPixel / 2.0f);
                int blockStartZ = Math.round((float)this.cz - (float)this.mapHeight * this.blocksPerPixel / 2.0f);
                int c = (int)Math.ceil(this.blocksPerPixel);
                double r = 0.0;
                double g = 0.0;
                double b = 0.0;
                for (int stepi = 0; stepi < c; ++stepi) {
                    for (int stepj = 0; stepj < c; ++stepj) {
                        int z;
                        int x = Math.round((float)blockStartX + (float)i * this.blocksPerPixel) + stepi;
                        if (!this.getContainer().currentAreaSelection.get(x, z = Math.round((float)blockStartZ + (float)j * this.blocksPerPixel) + stepj)) continue;
                        r += (double)rAdd;
                        g += (double)gAdd;
                        b += (double)bAdd;
                    }
                }
                g /= (double)(c * c);
                b /= (double)(c * c);
                if ((r /= (double)(c * c)) != 0.0) {
                    this.currentSelection.setColori(i, j, (int)r, (int)g, (int)b, (int)(this.alpha * 255.0f));
                    continue;
                }
                this.currentSelection.setColori(i, j, 0, 0, 0, 0);
            }
        }
    }

    @Override
    public ContainerZonePlan getContainer() {
        return (ContainerZonePlan)super.getContainer();
    }

    protected void actionPerformed(GuiButton button) {
        if (button == this.tool) {
            if (this.tool.displayString.equals("+")) {
                this.tool.displayString = "-";
                this.tool.getToolTip().remove(0);
                this.tool.getToolTip().add(new ToolTipLine(StringUtils.localize("tip.tool.remove")));
            } else {
                this.tool.displayString = "+";
                this.tool.getToolTip().remove(0);
                this.tool.getToolTip().add(new ToolTipLine(StringUtils.localize("tip.tool.add")));
            }
        } else if (button == this.fsButton) {
            this.toFullscreen();
        }
    }

    public void handleMouseInput() {
        int wheel;
        super.handleMouseInput();
        int mouseX = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        if (mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height && (wheel = Mouse.getEventDWheel()) != 0) {
            if (wheel > 0 && this.decBlocksPerPixel()) {
                this.uploadMap();
                this.refreshSelectedArea();
            } else if (wheel < 0 && this.incBlocksPerPixel()) {
                this.uploadMap();
                this.refreshSelectedArea();
            }
        }
    }

    private static class AreaSlot
    extends AdvancedSlot {
        public EnumColor color;

        public AreaSlot(GuiAdvancedInterface gui, int x, int y, EnumColor iColor) {
            super(gui, x, y);
            this.color = iColor;
        }

        @Override
        public IIcon getIcon() {
            return this.color.getIcon();
        }

        @Override
        public String getDescription() {
            return this.color.getLocalizedName();
        }
    }
}

