/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.map;

import buildcraft.api.core.INBTStoreable;
import buildcraft.robotics.map.MapChunk;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IntHashMap;

public class MapRegion
implements INBTStoreable {
    private final IntHashMap chunks = new IntHashMap();
    private final int x;
    private final int z;

    public MapRegion(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean hasChunk(int x, int z) {
        return this.chunks.containsItem(z << 4 | x);
    }

    public MapChunk getChunk(int x, int z) {
        int id = z << 4 | x;
        MapChunk chunk = (MapChunk)this.chunks.lookup(id);
        if (chunk == null) {
            chunk = new MapChunk(x, z);
            this.chunks.addKey(id, (Object)chunk);
        }
        return chunk;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.chunks.clearMap();
        if (tag != null) {
            for (int i = 0; i < 256; ++i) {
                if (!tag.hasKey("r" + i)) continue;
                MapChunk chunk = new MapChunk(tag.getCompoundTag("r" + i));
                this.chunks.addKey(i, (Object)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < 256; ++i) {
            MapChunk chunk = (MapChunk)this.chunks.lookup(i);
            if (chunk == null) continue;
            NBTTagCompound chunkNBT = new NBTTagCompound();
            MapChunk mapChunk = chunk;
            synchronized (mapChunk) {
                chunk.writeToNBT(chunkNBT);
            }
            tag.setTag("r" + i, (NBTBase)chunkNBT);
        }
    }
}

