/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.map;

import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.robotics.map.MapChunk;
import buildcraft.robotics.map.MapRegion;
import buildcraft.robotics.map.MapUtils;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MapWorld {
    private final LongHashMap regionMap;
    private final HashMap<Chunk, Integer> timeToUpdate = new HashMap();
    private final TLongLongHashMap regionUpdateTime;
    private final TLongHashSet updatedChunks;
    private final File location;

    public MapWorld(World world, File location) {
        this.regionMap = new LongHashMap();
        this.regionUpdateTime = new TLongLongHashMap();
        this.updatedChunks = new TLongHashSet();
        String saveFolder = world.provider.getSaveFolder();
        if (saveFolder == null) {
            saveFolder = "world";
        }
        this.location = new File(location, saveFolder);
        try {
            this.location.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MapRegion getRegion(int x, int z) {
        long id = MapUtils.getIDFromCoords(x, z);
        MapRegion region = (MapRegion)this.regionMap.getValueByKey(id);
        if (region == null) {
            region = new MapRegion(x, z);
            File target = new File(this.location, "r" + x + "," + z + ".nbt");
            if (target.exists()) {
                try {
                    FileInputStream f = new FileInputStream(target);
                    byte[] data = new byte[(int)target.length()];
                    f.read(data);
                    f.close();
                    NBTTagCompound nbt = NBTUtils.load(data);
                    if (nbt != null) {
                        region.readFromNBT(nbt);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.regionMap.add(id, (Object)region);
        }
        return region;
    }

    private MapChunk getChunk(int x, int z) {
        MapRegion region = this.getRegion(x >> 4, z >> 4);
        return region.getChunk(x & 0xF, z & 0xF);
    }

    public boolean hasChunk(int x, int z) {
        MapRegion region = this.getRegion(x >> 4, z >> 4);
        return region.hasChunk(x & 0xF, z & 0xF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        long[] chunkList;
        TLongHashSet object = this.updatedChunks;
        synchronized (object) {
            chunkList = this.updatedChunks.toArray();
            this.updatedChunks.clear();
        }
        for (long id : chunkList) {
            MapRegion region = (MapRegion)this.regionMap.getValueByKey(id);
            if (region == null) continue;
            NBTTagCompound output = new NBTTagCompound();
            region.writeToNBT(output);
            byte[] data = NBTUtils.save(output);
            File file = new File(this.location, "r" + MapUtils.getXFromID(id) + "," + MapUtils.getZFromID(id) + ".nbt");
            try {
                FileOutputStream f = new FileOutputStream(file);
                f.write(data);
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getColor(int x, int z) {
        MapChunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk.getColor(x & 0xF, z & 0xF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.timeToUpdate.size() > 0) {
            HashMap<Chunk, Integer> hashMap = this.timeToUpdate;
            synchronized (hashMap) {
                HashSet<Chunk> chunks = new HashSet<Chunk>();
                chunks.addAll(this.timeToUpdate.keySet());
                for (Chunk c : chunks) {
                    int v = this.timeToUpdate.get(c);
                    if (v > 1) {
                        this.timeToUpdate.put(c, v - 1);
                        continue;
                    }
                    try {
                        this.updateChunk(c);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChunk(Chunk rchunk) {
        long id = MapUtils.getIDFromCoords(rchunk.xPosition, rchunk.zPosition);
        MapChunk chunk = this.getChunk(rchunk.xPosition, rchunk.zPosition);
        chunk.update(rchunk);
        Object object = this.updatedChunks;
        synchronized (object) {
            this.updatedChunks.add(id);
        }
        object = this.timeToUpdate;
        synchronized (object) {
            this.timeToUpdate.remove(rchunk);
        }
        this.regionUpdateTime.put(id, new Date().getTime());
    }

    public long getUpdateTime(int x, int z) {
        return this.regionUpdateTime.get(MapUtils.getIDFromCoords(x, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChunkDelayed(Chunk chunk, byte time) {
        HashMap<Chunk, Integer> hashMap = this.timeToUpdate;
        synchronized (hashMap) {
            this.timeToUpdate.put(chunk, Integer.valueOf(time));
        }
    }
}

