/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.statements;

import buildcraft.api.robots.DockingStation;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.statements.StatementSlot;
import buildcraft.core.lib.inventory.filters.ArrayFluidFilter;
import buildcraft.core.lib.inventory.filters.ArrayStackOrListFilter;
import buildcraft.core.lib.inventory.filters.IFluidFilter;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.core.lib.inventory.filters.PassThroughFluidFilter;
import buildcraft.core.lib.inventory.filters.PassThroughStackFilter;
import buildcraft.core.lib.inventory.filters.StatementParameterStackFilter;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ActionRobotFilter
extends BCStatement
implements IActionInternal {
    public ActionRobotFilter() {
        super("buildcraft:robot.work_filter");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.robot.filter");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("buildcraftrobotics:triggers/action_robot_filter");
    }

    @Override
    public int minParameters() {
        return 1;
    }

    @Override
    public int maxParameters() {
        return 3;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    public static Collection<ItemStack> getGateFilterStacks(DockingStation station) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (StatementSlot slot : station.getActiveActions()) {
            if (!(slot.statement instanceof ActionRobotFilter)) continue;
            for (IStatementParameter p : slot.parameters) {
                StatementParameterItemStack param;
                ItemStack stack;
                if (p == null || !(p instanceof StatementParameterItemStack) || (stack = (param = (StatementParameterItemStack)p).getItemStack()) == null) continue;
                result.add(stack);
            }
        }
        return result;
    }

    public static IStackFilter getGateFilter(DockingStation station) {
        Collection<ItemStack> stacks = ActionRobotFilter.getGateFilterStacks(station);
        if (stacks.size() == 0) {
            return new PassThroughStackFilter();
        }
        return new ArrayStackOrListFilter(stacks.toArray(new ItemStack[stacks.size()]));
    }

    public static IFluidFilter getGateFluidFilter(DockingStation station) {
        Collection<ItemStack> stacks = ActionRobotFilter.getGateFilterStacks(station);
        if (stacks.size() == 0) {
            return new PassThroughFluidFilter();
        }
        return new ArrayFluidFilter(stacks.toArray(new ItemStack[stacks.size()]));
    }

    public static boolean canInteractWithItem(DockingStation station, IStackFilter filter, Class<?> actionClass) {
        boolean actionFound = false;
        for (StatementSlot s : station.getActiveActions()) {
            StatementParameterStackFilter param;
            if (!actionClass.isAssignableFrom(s.statement.getClass()) || (param = new StatementParameterStackFilter(s.parameters)).hasFilter() && !param.matches(filter)) continue;
            actionFound = true;
            break;
        }
        return actionFound;
    }

    public static boolean canInteractWithFluid(DockingStation station, IFluidFilter filter, Class<?> actionClass) {
        boolean actionFound = false;
        block0: for (StatementSlot s : station.getActiveActions()) {
            if (!actionClass.isAssignableFrom(s.statement.getClass())) continue;
            StatementParameterStackFilter param = new StatementParameterStackFilter(s.parameters);
            if (!param.hasFilter()) {
                actionFound = true;
                break;
            }
            for (ItemStack stack : param.getStacks()) {
                FluidStack fluid;
                if (stack == null || (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) == null || !filter.matches(fluid.getFluid())) continue;
                actionFound = true;
                continue block0;
            }
        }
        return actionFound;
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
    }
}

