/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.statements;

import buildcraft.api.core.IZone;
import buildcraft.api.items.IMapLocation;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementSlot;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.robotics.statements.StatementParameterMapLocation;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;

public class ActionRobotWorkInArea
extends BCStatement
implements IActionInternal {
    private final AreaType areaType;

    public ActionRobotWorkInArea(AreaType iAreaType) {
        super(iAreaType.getTag());
        this.areaType = iAreaType;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize(this.areaType.getUnlocalizedName());
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon(this.areaType.getIcon());
    }

    public static IZone getArea(StatementSlot slot) {
        if (slot.parameters[0] == null) {
            return null;
        }
        ItemStack stack = slot.parameters[0].getItemStack();
        if (stack == null || !(stack.getItem() instanceof IMapLocation)) {
            return null;
        }
        IMapLocation map = (IMapLocation)stack.getItem();
        return map.getZone(stack);
    }

    @Override
    public int minParameters() {
        return 1;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterMapLocation();
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public static enum AreaType {
        WORK("work_in_area"),
        LOAD_UNLOAD("load_unload_area");

        private final String name;

        private AreaType(String iName) {
            this.name = iName;
        }

        public String getTag() {
            return "buildcraft:robot." + this.name;
        }

        public String getUnlocalizedName() {
            return "gate.action.robot." + this.name;
        }

        public String getIcon() {
            return "buildcraftrobotics:triggers/action_robot_" + this.name;
        }
    }
}

