/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.power.ILaserTargetBlock;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.silicon.SiliconProxy;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.TileChargingTable;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.TileProgrammingTable;
import buildcraft.silicon.TileStampingTable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockLaserTable
extends BlockBuildCraft
implements ILaserTargetBlock {
    protected static final int TABLE_MAX = 6;

    public BlockLaserTable() {
        super(Material.iron);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        this.setHardness(10.0f);
        this.setCreativeTab(BCCreativeTab.get("main"));
        this.setPassCount(2);
        this.setAlphaPass(true);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return SiliconProxy.laserTableModel;
    }

    @Override
    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (super.onBlockActivated(world, i, j, k, entityplayer, par6, par7, par8, par9)) {
            return true;
        }
        if (entityplayer.isSneaking()) {
            return false;
        }
        if (!world.isRemote) {
            int meta = world.getBlockMetadata(i, j, k);
            entityplayer.openGui((Object)BuildCraftSilicon.instance, meta, world, i, j, k);
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileAssemblyTable();
            }
            case 1: {
                return new TileAdvancedCraftingTable();
            }
            case 2: {
                return new TileIntegrationTable();
            }
            case 3: {
                return new TileChargingTable();
            }
            case 4: {
                return new TileProgrammingTable();
            }
            case 5: {
                return new TileStampingTable();
            }
        }
        return null;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return null;
    }

    public int damageDropped(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 6; ++i) {
            par3List.add(new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getIconBlockNames() {
        return new String[]{"BuildCraft|Silicon:assemblyTable", "BuildCraft|Silicon:advancedCraftingTable", "BuildCraft|Silicon:integrationTable", "BuildCraft|Silicon:chargingTable", "BuildCraft|Silicon:programmingTable", "BuildCraft|Silicon:stampingTable"};
    }
}

