/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.slots.SlotOutput;
import buildcraft.core.lib.gui.slots.SlotValidated;
import buildcraft.silicon.TilePackager;
import buildcraft.silicon.gui.SlotPackager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerPackager
extends BuildCraftContainer {
    private final TilePackager tile;

    public ContainerPackager(InventoryPlayer inventoryplayer, TilePackager t) {
        super(t.getSizeInventory());
        int x;
        int y;
        int x2;
        this.tile = t;
        this.addSlotToContainer(new SlotValidated((IInventory)this.tile, 9, 124, 7));
        for (x2 = 0; x2 < 9; ++x2) {
            this.addSlotToContainer(new Slot((IInventory)this.tile, x2, 8 + x2 * 18, 84));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.addSlotToContainer(new SlotPackager(this.tile.inventoryPattern, x + y * 3, 30 + x * 18, 17 + y * 18));
            }
        }
        this.addSlotToContainer(new SlotOutput((IInventory)this.tile, 11, 123, 59));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, x + y * 9 + 9, 8 + x * 18, 115 + y * 18));
            }
        }
        for (x2 = 0; x2 < 9; ++x2) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, x2, 8 + x2 * 18, 173));
        }
        this.onCraftMatrixChanged((IInventory)this.tile);
    }

    @Override
    public ItemStack slotClick(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot = slotNum < 0 ? null : (Slot)this.inventorySlots.get(slotNum);
        ItemStack out = super.slotClick(slotNum, mouseButton, slot instanceof SlotPackager ? 0 : modifier, player);
        if (slot instanceof SlotPackager) {
            ItemStack stack;
            int idx = slot.getSlotIndex();
            ItemStack itemStack = stack = player != null && player.inventory != null ? player.inventory.getItemStack() : null;
            if (stack == null) {
                this.tile.setPatternSlot(idx, !this.tile.isPatternSlotSet(idx));
            } else {
                this.tile.setPatternSlot(idx, true);
            }
            this.tile.sendNetworkUpdate();
        }
        return out;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.tile.isUseableByPlayer(entityplayer);
    }
}

