/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.gui.ContainerAssemblyTable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiAssemblyTable
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftsilicon:textures/gui/assembly_table.png");
    private final TileAssemblyTable table;

    public GuiAssemblyTable(IInventory playerInventory, TileAssemblyTable assemblyTable) {
        super(new ContainerAssemblyTable(playerInventory, assemblyTable), assemblyTable, TEXTURE);
        this.table = assemblyTable;
        this.xSize = 176;
        this.ySize = 207;
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 4; ++i) {
                this.slots.add(new RecipeSlot(116 + 18 * j, 36 + 18 * i));
            }
        }
        this.updateRecipes();
    }

    public void updateRecipes() {
        HashSet<String> addedRecipes = new HashSet<String>();
        List<CraftingResult<ItemStack>> potentialRecipes = this.table.getPotentialOutputs();
        Iterator<CraftingResult<ItemStack>> cur = potentialRecipes.iterator();
        Set<String> plannedIcons = this.table.plannedOutputIcons.keySet();
        Iterator cur2 = plannedIcons.iterator();
        for (AdvancedSlot s : this.slots) {
            if (cur.hasNext()) {
                ((RecipeSlot)s).crafting = cur.next();
                ((RecipeSlot)s).craftable = true;
                addedRecipes.add(((RecipeSlot)s).crafting.recipe.getId());
                continue;
            }
            String recipe = null;
            while (cur2.hasNext() && (recipe == null || addedRecipes.contains(recipe))) {
                recipe = (String)cur2.next();
            }
            if (recipe != null && !addedRecipes.contains(recipe)) {
                ((RecipeSlot)s).crafting = this.table.plannedOutputIcons.get(recipe);
                ((RecipeSlot)s).craftable = false;
                continue;
            }
            ((RecipeSlot)s).crafting = null;
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        String title = StringUtils.localize("tile.assemblyTableBlock.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 15, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 97, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.updateRecipes();
        for (AdvancedSlot slot2 : this.slots) {
            RecipeSlot slot = (RecipeSlot)slot2;
            if (slot.crafting == null) continue;
            if (!slot.craftable) {
                this.drawTexturedModalRect(this.guiLeft + slot.x, this.guiTop + slot.y, 215, 1, 16, 16);
                continue;
            }
            if (this.table.isAssembling(slot.crafting.recipe)) {
                this.drawTexturedModalRect(this.guiLeft + slot.x, this.guiTop + slot.y, 196, 1, 16, 16);
                continue;
            }
            if (!this.table.isPlanned(slot.crafting.recipe)) continue;
            this.drawTexturedModalRect(this.guiLeft + slot.x, this.guiTop + slot.y, 177, 1, 16, 16);
        }
        int h = this.table.getProgressScaled(70);
        this.drawTexturedModalRect(this.guiLeft + 86, this.guiTop + 36 + 70 - h, 176, 18, 4, h);
        this.drawBackgroundSlots(x, y);
    }

    @Override
    protected void slotClicked(AdvancedSlot aslot, int mouseButton) {
        super.slotClicked(aslot, mouseButton);
        if (aslot instanceof RecipeSlot) {
            RecipeSlot slot = (RecipeSlot)aslot;
            if (slot.crafting == null) {
                return;
            }
            boolean select = !this.table.isPlanned(slot.crafting.recipe);
            String id = slot.crafting.recipe.getId();
            this.table.rpcSelectRecipe(id, select);
        }
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new LaserTableLedger());
        }
    }

    class RecipeSlot
    extends AdvancedSlot {
        public CraftingResult<ItemStack> crafting;
        public boolean craftable;

        public RecipeSlot(int x, int y) {
            super(GuiAssemblyTable.this, x, y);
        }

        @Override
        public ItemStack getItemStack() {
            if (this.crafting != null) {
                return (ItemStack)this.crafting.crafted;
            }
            return null;
        }
    }

    private class LaserTableLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public LaserTableLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiAssemblyTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiAssemblyTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiAssemblyTable.this.fontRendererObj.drawString(String.format("%d RF", ((GuiAssemblyTable)GuiAssemblyTable.this).table.clientRequiredEnergy), x + 22, y + 32, this.textColour);
            GuiAssemblyTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiAssemblyTable.this.fontRendererObj.drawString(String.format("%d RF", GuiAssemblyTable.this.table.getEnergy()), x + 22, y + 56, this.textColour);
            GuiAssemblyTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiAssemblyTable.this.fontRendererObj.drawString(String.format("%.1f RF/t", Float.valueOf((float)GuiAssemblyTable.this.table.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", Float.valueOf((float)GuiAssemblyTable.this.table.getRecentEnergyAverage() / 100.0f));
        }
    }
}

