/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.gui.ContainerIntegrationTable;
import buildcraft.silicon.gui.GuiLaserTable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiIntegrationTable
extends GuiLaserTable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftsilicon:textures/gui/integration_table.png");
    private static final int FLASH_DELAY = 3;
    private final TileIntegrationTable integrationTable;
    private boolean flash;
    private int flashDelay;

    public GuiIntegrationTable(InventoryPlayer playerInventory, TileIntegrationTable table) {
        super(playerInventory, new ContainerIntegrationTable(playerInventory, table), table, TEXTURE);
        this.integrationTable = table;
        this.xSize = 176;
        this.ySize = 186;
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.flashDelay <= 0) {
            this.flashDelay = 3;
            this.flash = !this.flash;
        } else {
            --this.flashDelay;
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.drawLedgers(par1, par2);
        String title = this.table.getInventoryName();
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        if (this.integrationTable.getEnergy() > 0) {
            int h = this.table.getProgressScaled(69);
            this.drawTexturedModalRect(this.guiLeft + 164, this.guiTop + 18 + 74 - h, 176, 18, 4, h);
        }
        if (this.integrationTable.getMaxExpansionCount() > 0) {
            for (int i = 8; i > this.integrationTable.getMaxExpansionCount(); --i) {
                this.drawTexturedModalRect(this.guiLeft + ContainerIntegrationTable.SLOT_X[i] - 1, this.guiTop + ContainerIntegrationTable.SLOT_Y[i] - 1, 180, 17, 18, 18);
            }
        }
    }
}

