/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.silicon.TileStampingTable;
import buildcraft.silicon.gui.ContainerStampingTable;
import buildcraft.silicon.gui.GuiLaserTable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiStampingTable
extends GuiLaserTable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftsilicon:textures/gui/stamper.png");
    private static final int FLASH_DELAY = 3;
    private final TileStampingTable integrationTable;
    private boolean flash;
    private int flashDelay;

    public GuiStampingTable(InventoryPlayer playerInventory, TileStampingTable table) {
        super(playerInventory, new ContainerStampingTable(playerInventory, table), table, TEXTURE);
        this.integrationTable = table;
        this.xSize = 176;
        this.ySize = 151;
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.flashDelay <= 0) {
            this.flashDelay = 3;
            this.flash = !this.flash;
        } else {
            --this.flashDelay;
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.drawLedgers(par1, par2);
        String title = this.table.getInventoryName();
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 5, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        if (this.integrationTable.getEnergy() > 0) {
            int progress = this.integrationTable.getProgressScaled(98);
            this.drawTexturedModalRect(this.guiLeft + 36, this.guiTop + 14, 0, this.flash ? 197 : 221, progress, 24);
        }
    }
}

