/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.render;

import buildcraft.core.lib.utils.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PackageFontRenderer
extends FontRenderer {
    private static final RenderItem itemRender = new RenderItem();
    private static final Minecraft mc = Minecraft.getMinecraft();
    private static final FontRenderer realRenderer = PackageFontRenderer.mc.fontRenderer;
    private final NBTTagCompound pkgTag;

    public PackageFontRenderer(ItemStack packageStack) {
        super(PackageFontRenderer.mc.gameSettings, new ResourceLocation("textures/font/ascii.png"), mc.getTextureManager(), PackageFontRenderer.mc.fontRenderer.getUnicodeFlag());
        this.pkgTag = NBTUtils.getItemData(packageStack);
    }

    public int getStringWidth(String s) {
        if (!s.contains("SPECIAL:")) {
            return realRenderer.getStringWidth(s);
        }
        return 21;
    }

    public int drawString(String s, int x, int y, int color, boolean shadow) {
        if (!s.contains("SPECIAL:")) {
            return realRenderer.drawString(s, x, y, color, shadow);
        }
        int begin = Integer.parseInt(s.substring(s.length() - 1)) * 3;
        int rx = x;
        for (int slotPos = begin; slotPos < begin + 3; ++slotPos) {
            GL11.glPushMatrix();
            if (this.pkgTag.hasKey("item" + slotPos)) {
                ItemStack slotStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)this.pkgTag.getCompoundTag("item" + slotPos));
                if (slotStack != null) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    FontRenderer font = slotStack.getItem().getFontRenderer(slotStack);
                    PackageFontRenderer.itemRender.zLevel = 200.0f;
                    if (font == null || font instanceof PackageFontRenderer) {
                        font = Minecraft.getMinecraft().fontRenderer;
                    }
                    itemRender.renderItemAndEffectIntoGUI(font, mc.getTextureManager(), slotStack, rx * 2, y * 2);
                    itemRender.renderItemOverlayIntoGUI(font, mc.getTextureManager(), slotStack, rx * 2, y * 2);
                    PackageFontRenderer.itemRender.zLevel = 0.0f;
                } else {
                    realRenderer.drawString("X", rx, y, 0xFF0000);
                }
            }
            rx += 7;
            GL11.glPopMatrix();
        }
        return rx;
    }
}

