/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.render;

import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.render.FakeBlock;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.render.SubIcon;
import buildcraft.silicon.SiliconProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderLaserTable
implements ISimpleBlockRenderingHandler {
    private void workaround17(int x, int y, int z) {
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        BlockBuildCraft bcBlock = (BlockBuildCraft)block;
        switch (metadata) {
            case 0: {
                this.renderAssemblyTable(renderer, true, 0, 0, 0, bcBlock);
                break;
            }
            case 1: {
                this.renderAdvancedCraftingTable(renderer, true, 0, 0, 0, bcBlock);
                break;
            }
            case 2: {
                this.renderIntegrationTable(renderer, true, 0, 0, 0, bcBlock);
                break;
            }
            case 3: {
                this.renderChargingTable(renderer, true, 0, 0, 0, bcBlock);
                break;
            }
            case 4: {
                this.renderProgrammingTable(renderer, true, 0, 0, 0, bcBlock);
                break;
            }
            case 5: {
                this.renderStampingTable(renderer, true, 0, 0, 0, bcBlock);
            }
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BlockBuildCraft bcBlock = (BlockBuildCraft)block;
        switch (world.getBlockMetadata(x, y, z)) {
            case 0: {
                this.renderAssemblyTable(renderer, false, x, y, z, bcBlock);
                break;
            }
            case 1: {
                this.renderAdvancedCraftingTable(renderer, false, x, y, z, bcBlock);
                break;
            }
            case 2: {
                this.renderIntegrationTable(renderer, false, x, y, z, bcBlock);
                break;
            }
            case 3: {
                this.renderChargingTable(renderer, false, x, y, z, bcBlock);
                break;
            }
            case 4: {
                this.renderProgrammingTable(renderer, false, x, y, z, bcBlock);
                break;
            }
            case 5: {
                this.renderStampingTable(renderer, false, x, y, z, bcBlock);
            }
        }
        return true;
    }

    private void renderCube(RenderBlocks renderer, boolean isInventory, int xPos, int yPos, int zPos, float xB, float yB, float zB, int w, int h, int d, int topX, int topY, IIcon base, int mask) {
        int xI = (int)(xB * 16.0f);
        int yI = 16 - (int)(yB * 16.0f) - h;
        int zI = (int)(zB * 16.0f);
        FakeBlock block = FakeBlock.INSTANCE;
        block.setRenderMask(mask);
        block.setColor(0xFFFFFF);
        IIcon[] icons = block.getTextureState().popArray();
        icons[0] = new SubIcon(base, topX + w - xI, topY - zI, 16, 16, 64);
        icons[1] = new SubIcon(base, topX - xI, topY - zI, 16, 16, 64);
        icons[2] = new SubIcon(base, topX - xI, topY + d - yI, 16, 16, 64);
        icons[3] = new SubIcon(base, topX + w + d - xI, topY + d - yI, 16, 16, 64);
        icons[4] = new SubIcon(base, topX - d - zI, topY + d - yI, 16, 16, 64);
        icons[5] = new SubIcon(base, topX + w - zI, topY + d - yI, 16, 16, 64);
        renderer.setRenderBounds((double)xB, (double)yB, (double)zB, (double)(xB + (float)w / 16.0f), (double)(yB + (float)h / 16.0f), (double)(zB + (float)d / 16.0f));
        if (isInventory) {
            RenderUtils.drawBlockItem(renderer, Tessellator.instance, (Block)block, 0);
        } else {
            renderer.renderStandardBlockWithColorMultiplier((Block)block, xPos, yPos, zPos, 1.0f, 1.0f, 1.0f);
        }
        block.getTextureState().pushArray();
        block.setRenderMask(63);
    }

    private void renderAssemblyTable(RenderBlocks renderer, boolean isInv, int x, int y, int z, BlockBuildCraft block) {
        if (!isInv && block.getCurrentRenderPass() != 0) {
            this.workaround17(x, y, z);
            return;
        }
        IIcon base = block.getIcon(0, 0);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.0f, 16, 2, 16, 16, 21, base, 63);
        this.renderCube(renderer, isInv, x, y, z, 0.0625f, 0.125f, 0.0625f, 14, 1, 14, 18, 39, base, 60);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.1875f, 0.0f, 16, 5, 16, 16, 0, base, 63);
    }

    private void renderChargingTable(RenderBlocks renderer, boolean isInv, int x, int y, int z, BlockBuildCraft block) {
        if (!isInv && block.getCurrentRenderPass() != 0) {
            this.workaround17(x, y, z);
            return;
        }
        IIcon base = block.getIcon(0, 3);
        this.renderCube(renderer, isInv, x, y, z, 0.0625f, 0.0f, 0.0625f, 14, 5, 14, 14, 19, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.8125f, 0.0f, 0.0f, 3, 5, 3, 3, 6, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.8125f, 0.0f, 0.8125f, 3, 5, 3, 3, 6, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.8125f, 3, 5, 3, 3, 6, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.0f, 3, 5, 3, 3, 6, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.3125f, 0.0f, 16, 3, 16, 16, 0, base, 63);
    }

    private void renderProgrammingTable(RenderBlocks renderer, boolean isInv, int x, int y, int z, BlockBuildCraft block) {
        IIcon base = block.getIcon(0, 4);
        if (block.getCurrentRenderPass() != 0) {
            this.renderCube(renderer, isInv, x, y, z, 0.25f, 0.375f, 0.25f, 8, 2, 8, 8, 48, base, 2);
            if (!isInv) {
                return;
            }
        }
        this.renderCube(renderer, isInv, x, y, z, 0.0625f, 0.0f, 0.0625f, 14, 3, 14, 14, 23, base, 63);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.0f, 4, 3, 4, 4, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.75f, 0.0f, 0.0f, 4, 3, 4, 4, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.75f, 4, 3, 4, 4, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.75f, 0.0f, 0.75f, 4, 3, 4, 4, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.1875f, 0.0f, 4, 5, 16, 16, 2, base, 62);
        this.renderCube(renderer, isInv, x, y, z, 0.25f, 0.1875f, 0.75f, 8, 5, 4, 28, 9, base, 14);
        this.renderCube(renderer, isInv, x, y, z, 0.3125f, 0.1875f, 0.3125f, 6, 2, 6, 6, 40, base, 62);
        this.renderCube(renderer, isInv, x, y, z, 0.25f, 0.1875f, 0.0f, 8, 5, 4, 28, 0, base, 14);
        this.renderCube(renderer, isInv, x, y, z, 0.75f, 0.1875f, 0.0f, 4, 5, 16, 40, 43, base, 62);
    }

    private void renderIntegrationTable(RenderBlocks renderer, boolean isInv, int x, int y, int z, BlockBuildCraft block) {
        IIcon base = block.getIcon(0, 2);
        if (!isInv && block.getCurrentRenderPass() != 0) {
            this.workaround17(x, y, z);
            return;
        }
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.0f, 16, 1, 16, 16, 21, base, 63);
        this.renderCube(renderer, isInv, x, y, z, 0.0625f, 0.0625f, 0.0625f, 4, 2, 4, 4, 0, base, 60);
        this.renderCube(renderer, isInv, x, y, z, 0.6875f, 0.0625f, 0.0625f, 4, 2, 4, 4, 0, base, 60);
        this.renderCube(renderer, isInv, x, y, z, 0.0625f, 0.0625f, 0.6875f, 4, 2, 4, 4, 0, base, 60);
        this.renderCube(renderer, isInv, x, y, z, 0.6875f, 0.0625f, 0.6875f, 4, 2, 4, 4, 0, base, 60);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.1875f, 0.0f, 5, 5, 16, 16, 0, base, 63);
        this.renderCube(renderer, isInv, x, y, z, 0.3125f, 0.1875f, 0.6875f, 6, 5, 5, 47, 10, base, 15);
        this.renderCube(renderer, isInv, x, y, z, 0.3125f, 0.1875f, 0.3125f, 6, 4, 6, 6, 38, base, 63);
        this.renderCube(renderer, isInv, x, y, z, 0.3125f, 0.1875f, 0.0f, 6, 5, 5, 47, 0, base, 15);
        this.renderCube(renderer, isInv, x, y, z, 0.6875f, 0.1875f, 0.0f, 5, 5, 16, 38, 43, base, 63);
    }

    private void renderAdvancedCraftingTable(RenderBlocks renderer, boolean isInv, int x, int y, int z, BlockBuildCraft block) {
        if (!isInv && block.getCurrentRenderPass() != 0) {
            this.workaround17(x, y, z);
            return;
        }
        IIcon base = block.getIcon(0, 1);
        this.renderCube(renderer, isInv, x, y, z, 0.125f, 0.0f, 0.125f, 12, 3, 12, 12, 21, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.0f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.8125f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.8125f, 0.0f, 0.0f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.8125f, 0.0f, 0.8125f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.1875f, 0.0f, 16, 5, 16, 16, 0, base, 63);
    }

    private void renderStampingTable(RenderBlocks renderer, boolean isInv, int x, int y, int z, BlockBuildCraft block) {
        if (!isInv && block.getCurrentRenderPass() != 0) {
            this.workaround17(x, y, z);
            return;
        }
        IIcon base = block.getIcon(0, 5);
        this.renderCube(renderer, isInv, x, y, z, 0.125f, 0.0f, 0.125f, 12, 3, 12, 12, 21, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.0f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.0f, 0.8125f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.8125f, 0.0f, 0.0f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.8125f, 0.0f, 0.8125f, 3, 3, 3, 3, 0, base, 61);
        this.renderCube(renderer, isInv, x, y, z, 0.0f, 0.1875f, 0.0f, 16, 5, 16, 16, 0, base, 63);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return SiliconProxy.laserTableModel;
    }
}

