/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.block.IComparatorInventory;
import buildcraft.transport.TileFilteredBuffer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockFilteredBuffer
extends BlockBuildCraft
implements IComparatorInventory {
    public BlockFilteredBuffer() {
        super(Material.iron);
        this.setHardness(5.0f);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileFilteredBuffer();
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (super.onBlockActivated(world, x, y, z, entityplayer, par6, par7, par8, par9)) {
            return true;
        }
        if (entityplayer.isSneaking()) {
            return false;
        }
        if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().getItem() instanceof IItemPipe) {
            return false;
        }
        if (!world.isRemote) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 60, world, x, y, z);
        }
        return true;
    }

    @Override
    public boolean doesSlotCountComparator(TileEntity tile, int slot, ItemStack stack) {
        return ((TileFilteredBuffer)tile).getFilters().getStackInSlot(slot) != null;
    }
}

