/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.JavaTools;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.BlockSpring;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.FacadePluggable;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFacade
extends ItemBuildCraft
implements IFacadeItem,
IPipePluggableItem {
    public static final ArrayList<ItemStack> allFacades = new ArrayList();
    public static final ArrayList<ItemStack> allHollowFacades = new ArrayList();
    public static final ArrayList<String> allFacadeIDs = new ArrayList();
    public static final ArrayList<String> blacklistedFacades = new ArrayList();
    private static final Block NULL_BLOCK = null;
    private static final ItemStack NO_MATCH = new ItemStack(NULL_BLOCK, 0, 0);
    private static final Block[] PREVIEW_FACADES = new Block[]{Blocks.planks, Blocks.stonebrick, Blocks.glass};
    private static int RANDOM_FACADE_ID = -1;

    public ItemFacade() {
        super(BuildCraftTransport.showAllFacadesCreative ? BCCreativeTab.get("facades") : BCCreativeTab.get("main"));
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        switch (this.getFacadeType(itemstack)) {
            case Basic: {
                FacadeState[] states = ItemFacade.getFacadeStates(itemstack);
                String displayName = states.length > 0 ? ItemFacade.getFacadeStateDisplayName(states[0]) : "CORRUPT";
                return super.getItemStackDisplayName(itemstack) + ": " + displayName;
            }
            case Phased: {
                return StringUtils.localize("item.FacadePhased.name");
            }
        }
        return "";
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "item.Facade";
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean debug) {
        for (FacadeState state : ItemFacade.getFacadeStates(stack)) {
            if (state == null || state.transparent || state.block == null || Item.getItemFromBlock((Block)state.block) == null) continue;
            Item.getItemFromBlock((Block)state.block).addInformation(new ItemStack(state.block, 1, state.metadata), player, list, debug);
        }
        if (this.getFacadeType(stack) == FacadeType.Phased) {
            String stateString = StringUtils.localize("item.FacadePhased.state");
            FacadeState defaultState = null;
            for (FacadeState state : ItemFacade.getFacadeStates(stack)) {
                if (state.wire == null) {
                    defaultState = state;
                    continue;
                }
                list.add(String.format(stateString, state.wire.getColor(), ItemFacade.getFacadeStateDisplayName(state)));
            }
            if (defaultState != null) {
                list.add(1, String.format(StringUtils.localize("item.FacadePhased.state_default"), ItemFacade.getFacadeStateDisplayName(defaultState)));
            }
        }
    }

    public static String getFacadeStateDisplayName(FacadeState state) {
        if (state.block == null) {
            return StringUtils.localize("item.FacadePhased.state_transparent");
        }
        int meta = state.metadata;
        if (state.block.getRenderType() == 31) {
            meta &= 3;
        } else if (state.block.getRenderType() == 39 && meta > 2) {
            meta = 2;
        }
        String s = CoreProxy.proxy.getItemDisplayName(new ItemStack(state.block, 1, meta));
        if (state.hollow) {
            s = s + " (" + StringUtils.localize("item.Facade.state_hollow") + ")";
        }
        return s;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        if (BuildCraftTransport.showAllFacadesCreative) {
            for (ItemStack stack : allFacades) {
                itemList.add(stack);
            }
            for (ItemStack stack : allHollowFacades) {
                itemList.add(stack);
            }
        } else {
            ArrayList<ItemStack> hollowFacades = new ArrayList<ItemStack>();
            for (Block b : PREVIEW_FACADES) {
                if (!ItemFacade.isBlockValidForFacade(b) || ItemFacade.isBlockBlacklisted(b)) continue;
                ItemStack facade = this.getFacadeForBlock(b, 0);
                itemList.add(facade);
                FacadeState state = ItemFacade.getFacadeStates(facade)[0];
                hollowFacades.add(ItemFacade.getFacade(new FacadeState(state.block, state.metadata, state.wire, true)));
            }
            if (RANDOM_FACADE_ID < 0) {
                RANDOM_FACADE_ID = BuildCraftCore.random.nextInt(allFacades.size());
            }
            itemList.add(allFacades.get(RANDOM_FACADE_ID));
            itemList.addAll(hollowFacades);
            itemList.add(allHollowFacades.get(RANDOM_FACADE_ID));
        }
    }

    public void initialize() {
        for (Object o : Block.blockRegistry) {
            Item item;
            Block b = (Block)o;
            if (!ItemFacade.isBlockValidForFacade(b) || (item = Item.getItemFromBlock((Block)b)) == null || ItemFacade.isBlockBlacklisted(b)) continue;
            this.registerValidFacades(b, item);
        }
    }

    private void registerValidFacades(Block block, Item item) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(16);
        try {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                for (CreativeTabs ct : item.getCreativeTabs()) {
                    block.getSubBlocks(item, ct, stacks);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    stacks.add(new ItemStack(item, 1, i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ItemStack stack : stacks) {
            try {
                int i = stack.getItemDamage();
                if (block.hasTileEntity(i)) continue;
                try {
                    if (stack.getDisplayName() == null) continue;
                    if (Strings.isNullOrEmpty((String)stack.getUnlocalizedName())) {
                    }
                }
                catch (Throwable t) {}
                continue;
                this.addFacade(stack);
            }
            catch (IndexOutOfBoundsException i) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static boolean isBlockBlacklisted(Block block) {
        String blockName = Block.blockRegistry.getNameForObject((Object)block);
        if (blockName == null) {
            return true;
        }
        for (String blacklistedBlock : blacklistedFacades) {
            if (!blockName.equals(blacklistedBlock)) continue;
            return true;
        }
        for (String blacklistedBlock : BuildCraftTransport.facadeBlacklist) {
            if (!blockName.equals(JavaTools.stripSurroundingQuotes(blacklistedBlock))) continue;
            return true ^ BuildCraftTransport.facadeTreatBlacklistAsWhitelist;
        }
        return false ^ BuildCraftTransport.facadeTreatBlacklistAsWhitelist;
    }

    private static boolean isBlockValidForFacade(Block block) {
        try {
            if (block.getBlockBoundsMinX() != 0.0 || block.getBlockBoundsMinY() != 0.0 || block.getBlockBoundsMinZ() != 0.0) {
                return false;
            }
            if (block.getBlockBoundsMaxX() != 1.0 || block.getBlockBoundsMaxY() != 1.0 || block.getBlockBoundsMaxZ() != 1.0) {
                return false;
            }
            return !(block instanceof BlockSpring) && !(block instanceof BlockGenericPipe);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static FacadeState[] getFacadeStates(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return new FacadeState[0];
        }
        NBTTagCompound nbt = stack.getTagCompound();
        if (!(nbt = ItemFacade.migrate(stack, nbt)).hasKey("states")) {
            return new FacadeState[0];
        }
        return FacadeState.readArray(nbt.getTagList("states", 10));
    }

    private static NBTTagCompound migrate(ItemStack stack, NBTTagCompound nbt) {
        Block block = null;
        Block blockAlt = null;
        int metadata = 0;
        PipeWire wire = null;
        if (nbt.hasKey("id")) {
            block = (Block)Block.blockRegistry.getObjectById(nbt.getInteger("id"));
        } else if (nbt.hasKey("name")) {
            block = (Block)Block.blockRegistry.getObject(nbt.getString("name"));
        }
        if (nbt.hasKey("name_alt")) {
            blockAlt = (Block)Block.blockRegistry.getObject(nbt.getString("name_alt"));
        }
        if (nbt.hasKey("meta")) {
            metadata = nbt.getInteger("meta");
        }
        int metadataAlt = nbt.hasKey("meta_alt") ? nbt.getInteger("meta_alt") : stack.getItemDamage() & 0xF;
        if (nbt.hasKey("wire")) {
            wire = PipeWire.fromOrdinal(nbt.getInteger("wire"));
        }
        if (block != null) {
            FacadeState[] states;
            FacadeState mainState = FacadeState.create(block, metadata);
            if (blockAlt != null && wire != null) {
                FacadeState altState = FacadeState.create(blockAlt, metadataAlt, wire);
                states = new FacadeState[]{mainState, altState};
            } else {
                states = new FacadeState[]{mainState};
            }
            NBTTagCompound newNbt = ItemFacade.getFacade(states).getTagCompound();
            stack.setTagCompound(newNbt);
            return newNbt;
        }
        return nbt;
    }

    @Override
    public Block[] getBlocksForFacade(ItemStack stack) {
        FacadeState[] states = ItemFacade.getFacadeStates(stack);
        Block[] blocks = new Block[states.length];
        for (int i = 0; i < states.length; ++i) {
            blocks[i] = states[i].block;
        }
        return blocks;
    }

    @Override
    public int[] getMetaValuesForFacade(ItemStack stack) {
        FacadeState[] states = ItemFacade.getFacadeStates(stack);
        int[] meta = new int[states.length];
        for (int i = 0; i < states.length; ++i) {
            meta[i] = states[i].metadata;
        }
        return meta;
    }

    @Override
    public FacadeType getFacadeType(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return FacadeType.Basic;
        }
        NBTTagCompound nbt = stack.getTagCompound();
        if (!nbt.hasKey("type")) {
            return FacadeType.Basic;
        }
        return FacadeType.fromOrdinal(nbt.getInteger("type"));
    }

    @Override
    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public void addFacade(ItemStack itemStack) {
        Block block;
        if (itemStack.stackSize == 0) {
            itemStack.stackSize = 1;
        }
        if ((block = Block.getBlockFromItem((Item)itemStack.getItem())) == null) {
            return;
        }
        if (!block.getMaterial().blocksMovement()) {
            return;
        }
        String recipeId = "buildcraft:facade{" + Block.blockRegistry.getNameForObject((Object)block) + "#" + itemStack.getItemDamage() + "}";
        ItemStack facade = this.getFacadeForBlock(block, itemStack.getItemDamage());
        if (!allFacadeIDs.contains(recipeId)) {
            allFacadeIDs.add(recipeId);
            allFacades.add(facade);
            ItemStack facade6 = facade.copy();
            facade6.stackSize = 6;
            FacadeState state = ItemFacade.getFacadeStates(facade6)[0];
            ItemStack facadeHollow = ItemFacade.getFacade(new FacadeState(state.block, state.metadata, state.wire, true));
            allHollowFacades.add(facadeHollow);
            ItemStack facade6Hollow = facadeHollow.copy();
            facade6Hollow.stackSize = 6;
            if (Loader.isModLoaded((String)"BuildCraft|Silicon") && !BuildCraftTransport.facadeForceNonLaserRecipe) {
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId, 8000, facade6, new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack);
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":hollow", 8000, facade6Hollow, new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack);
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":toHollow", 160, facadeHollow, facade);
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":fromHollow", 160, facade, facadeHollow);
            } else {
                GameRegistry.addShapedRecipe((ItemStack)facade6, (Object[])new Object[]{"t ", "ts", "t ", Character.valueOf('t'), itemStack, Character.valueOf('s'), BuildCraftTransport.pipeStructureCobblestone});
                GameRegistry.addShapedRecipe((ItemStack)facade6Hollow, (Object[])new Object[]{"t ", " s", "t ", Character.valueOf('t'), itemStack, Character.valueOf('s'), BuildCraftTransport.pipeStructureCobblestone});
            }
        }
    }

    public static void blacklistFacade(String blockName) {
        if (!blacklistedFacades.contains(blockName)) {
            blacklistedFacades.add(blockName);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    @Override
    public ItemStack getFacadeForBlock(Block block, int metadata) {
        return ItemFacade.getFacade(FacadeState.create(block, metadata));
    }

    public static ItemStack getAdvancedFacade(PipeWire wire, Block block, int metadata, Block blockAlt, int metaDataAlt) {
        return ItemFacade.getFacade(FacadeState.create(block, metadata), FacadeState.create(blockAlt, metaDataAlt, wire));
    }

    public static ItemStack getFacade(FacadeState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        boolean basic = states.length == 1 && states[0].wire == null;
        ItemStack stack = new ItemStack((Item)BuildCraftTransport.facadeItem, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setByte("type", (byte)(basic ? FacadeType.Basic : FacadeType.Phased).ordinal());
        nbt.setTag("states", (NBTBase)FacadeState.writeArray(states));
        stack.setTagCompound(nbt);
        return stack;
    }

    @Override
    public PipePluggable createPipePluggable(IPipe pipe, ForgeDirection side, ItemStack stack) {
        return new FacadePluggable(ItemFacade.getFacadeStates(stack));
    }

    public class FacadeRecipe
    implements IRecipe {
        public boolean matches(InventoryCrafting inventorycrafting, World world) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            return facade != null && facade[0] != null && ((Block[])facade[0]).length == 1;
        }

        public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            if (facade == null || ((Block[])facade[0]).length != 1) {
                return null;
            }
            Block block = ((Block[])facade[0])[0];
            ItemStack originalFacade = (ItemStack)facade[1];
            if (block == null) {
                return null;
            }
            return this.getNextFacadeItemStack(block, originalFacade);
        }

        private Object[] getFacadeBlockFromCraftingGrid(InventoryCrafting inventorycrafting) {
            ItemStack slotmatch = null;
            int countOfItems = 0;
            for (int i = 0; i < inventorycrafting.getSizeInventory(); ++i) {
                ItemStack slot = inventorycrafting.getStackInSlot(i);
                if (slot != null && slot.getItem() == ItemFacade.this && slotmatch == null) {
                    slotmatch = slot;
                    ++countOfItems;
                } else if (slot != null) {
                    slotmatch = NO_MATCH;
                }
                if (countOfItems <= true) continue;
                return null;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                return new Object[]{ItemFacade.this.getBlocksForFacade(slotmatch), slotmatch};
            }
            return null;
        }

        private ItemStack getNextFacadeItemStack(Block block, ItemStack originalFacade) {
            int blockMeta;
            int stackMeta = blockMeta = ItemFacade.this.getMetaValuesForFacade(originalFacade)[0];
            switch (block.getRenderType()) {
                case 31: {
                    if ((blockMeta & 0xC) == 0) {
                        stackMeta = blockMeta & 3 | 4;
                        break;
                    }
                    if ((blockMeta & 8) == 0) {
                        stackMeta = blockMeta & 3 | 8;
                        break;
                    }
                    if ((blockMeta & 4) != 0) break;
                    stackMeta = blockMeta & 3;
                    break;
                }
                case 39: {
                    if (blockMeta >= 2 && blockMeta < 4) {
                        stackMeta = blockMeta + 1;
                        break;
                    }
                    if (blockMeta != 4) break;
                    stackMeta = 2;
                }
            }
            return ItemFacade.this.getFacadeForBlock(block, stackMeta);
        }

        public int getRecipeSize() {
            return 1;
        }

        public ItemStack getRecipeOutput() {
            return null;
        }
    }

    public static class FacadeState {
        public final Block block;
        public final int metadata;
        public final boolean transparent;
        public final boolean hollow;
        public final PipeWire wire;

        public FacadeState(Block block, int metadata, PipeWire wire) {
            this.block = block;
            this.metadata = metadata;
            this.wire = wire;
            this.transparent = false;
            this.hollow = false;
        }

        public FacadeState(Block block, int metadata, PipeWire wire, boolean hollow) {
            this.block = block;
            this.metadata = metadata;
            this.wire = wire;
            this.transparent = false;
            this.hollow = hollow;
        }

        public FacadeState(NBTTagCompound nbt) {
            this.block = nbt.hasKey("block") ? (Block)Block.blockRegistry.getObject(nbt.getString("block")) : null;
            this.metadata = nbt.getByte("metadata");
            this.wire = nbt.hasKey("wire") ? PipeWire.fromOrdinal(nbt.getByte("wire")) : null;
            this.transparent = nbt.hasKey("transparent") && nbt.getBoolean("transparent");
            this.hollow = nbt.hasKey("hollow") && nbt.getBoolean("hollow");
        }

        private FacadeState(PipeWire wire) {
            this.block = null;
            this.metadata = 0;
            this.wire = wire;
            this.transparent = true;
            this.hollow = false;
        }

        public static FacadeState create(Block block, int metadata) {
            return FacadeState.create(block, metadata, null);
        }

        public static FacadeState create(Block block, int metadata, PipeWire wire) {
            return new FacadeState(block, metadata, wire);
        }

        public static FacadeState createTransparent(PipeWire wire) {
            return new FacadeState(wire);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            if (this.block != null) {
                nbt.setString("block", Block.blockRegistry.getNameForObject((Object)this.block));
            }
            nbt.setByte("metadata", (byte)this.metadata);
            if (this.wire != null) {
                nbt.setByte("wire", (byte)this.wire.ordinal());
            }
            nbt.setBoolean("transparent", this.transparent);
            nbt.setBoolean("hollow", this.hollow);
        }

        public static NBTTagList writeArray(FacadeState[] states) {
            if (states == null) {
                return null;
            }
            NBTTagList list = new NBTTagList();
            for (FacadeState state : states) {
                NBTTagCompound stateNBT = new NBTTagCompound();
                state.writeToNBT(stateNBT);
                list.appendTag((NBTBase)stateNBT);
            }
            return list;
        }

        public static FacadeState[] readArray(NBTTagList list) {
            if (list == null) {
                return null;
            }
            int length = list.tagCount();
            FacadeState[] states = new FacadeState[length];
            for (int i = 0; i < length; ++i) {
                states[i] = new FacadeState(list.getCompoundTagAt(i));
            }
            return states;
        }
    }
}

