/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.Position;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.transport.TransportProxy;
import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TravelingItem {
    public static final TravelingItemCache serverCache = new TravelingItemCache();
    public static final TravelingItemCache clientCache = new TravelingItemCache();
    public static final InsertionHandler DEFAULT_INSERTION_HANDLER = new InsertionHandler();
    private static int maxId = 0;
    public final EnumSet<ForgeDirection> blacklist = EnumSet.noneOf(ForgeDirection.class);
    public double xCoord;
    public double yCoord;
    public double zCoord;
    public final int id;
    public boolean toCenter = true;
    public EnumColor color;
    public ForgeDirection input = ForgeDirection.UNKNOWN;
    public ForgeDirection output = ForgeDirection.UNKNOWN;
    public int displayList;
    public boolean hasDisplayList;
    protected float speed = 0.01f;
    protected ItemStack itemStack;
    protected TileEntity container;
    protected NBTTagCompound extraData;
    protected InsertionHandler insertionHandler = DEFAULT_INSERTION_HANDLER;

    protected TravelingItem(int id) {
        this.id = id;
    }

    public static TravelingItem make(int id) {
        TravelingItem item = new TravelingItem(id);
        TravelingItem.getCache().cache(item);
        return item;
    }

    public static TravelingItem make() {
        return TravelingItem.make(maxId < Short.MAX_VALUE ? (maxId = maxId + 1) : (maxId = Short.MIN_VALUE));
    }

    public static TravelingItem make(double x, double y, double z, ItemStack stack) {
        TravelingItem item = TravelingItem.make();
        item.xCoord = x;
        item.yCoord = y;
        item.zCoord = z;
        item.itemStack = stack.copy();
        return item;
    }

    public static TravelingItem make(NBTTagCompound nbt) {
        TravelingItem item = TravelingItem.make();
        item.readFromNBT(nbt);
        return item;
    }

    public static TravelingItemCache getCache() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return clientCache;
        }
        return serverCache;
    }

    public void setPosition(double x, double y, double z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public void movePosition(double x, double y, double z) {
        this.xCoord += x;
        this.yCoord += y;
        this.zCoord += z;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack item) {
        this.itemStack = item;
    }

    public TileEntity getContainer() {
        return this.container;
    }

    public void setContainer(TileEntity container) {
        this.container = container;
    }

    public NBTTagCompound getExtraData() {
        if (this.extraData == null) {
            this.extraData = new NBTTagCompound();
        }
        return this.extraData;
    }

    public boolean hasExtraData() {
        return this.extraData != null;
    }

    public void setInsertionHandler(InsertionHandler handler) {
        if (handler == null) {
            return;
        }
        this.insertionHandler = handler;
    }

    public InsertionHandler getInsertionHandler() {
        return this.insertionHandler;
    }

    public void reset() {
        this.toCenter = true;
        this.blacklist.clear();
        this.input = ForgeDirection.UNKNOWN;
        this.output = ForgeDirection.UNKNOWN;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.setPosition(data.getDouble("x"), data.getDouble("y"), data.getDouble("z"));
        this.setSpeed(data.getFloat("speed"));
        this.setItemStack(ItemStack.loadItemStackFromNBT((NBTTagCompound)data.getCompoundTag("Item")));
        this.toCenter = data.getBoolean("toCenter");
        this.input = ForgeDirection.getOrientation((int)data.getByte("input"));
        this.output = ForgeDirection.getOrientation((int)data.getByte("output"));
        byte c = data.getByte("color");
        if (c != -1) {
            this.color = EnumColor.fromId(c);
        }
        if (data.hasKey("extraData")) {
            this.extraData = data.getCompoundTag("extraData");
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        data.setDouble("x", this.xCoord);
        data.setDouble("y", this.yCoord);
        data.setDouble("z", this.zCoord);
        data.setFloat("speed", this.getSpeed());
        NBTTagCompound itemStackTag = new NBTTagCompound();
        this.getItemStack().writeToNBT(itemStackTag);
        data.setTag("Item", (NBTBase)itemStackTag);
        data.setBoolean("toCenter", this.toCenter);
        data.setByte("input", (byte)this.input.ordinal());
        data.setByte("output", (byte)this.output.ordinal());
        data.setByte("color", this.color != null ? (byte)this.color.ordinal() : (byte)-1);
        if (this.extraData != null) {
            data.setTag("extraData", (NBTBase)this.extraData);
        }
    }

    public EntityItem toEntityItem() {
        if (this.container != null && !this.container.getWorldObj().isRemote) {
            if (this.getItemStack().stackSize <= 0) {
                return null;
            }
            Position motion = new Position(0.0, 0.0, 0.0, this.output);
            motion.moveForwards(0.1 + (double)(this.getSpeed() * 2.0f));
            EntityItem entity = new EntityItem(this.container.getWorldObj(), this.xCoord, this.yCoord, this.zCoord, this.getItemStack());
            entity.lifespan = BuildCraftCore.itemLifespan * 20;
            entity.delayBeforeCanPickup = 10;
            float f3 = 0.0f + this.container.getWorldObj().rand.nextFloat() * 0.04f - 0.02f;
            entity.motionX = (double)((float)this.container.getWorldObj().rand.nextGaussian() * f3) + motion.x;
            entity.motionY = (double)((float)this.container.getWorldObj().rand.nextGaussian() * f3) + motion.y;
            entity.motionZ = (double)((float)this.container.getWorldObj().rand.nextGaussian() * f3) + motion.z;
            return entity;
        }
        return null;
    }

    public float getEntityBrightness(float f) {
        int i = MathHelper.floor_double((double)this.xCoord);
        int j = MathHelper.floor_double((double)this.zCoord);
        if (this.container != null && this.container.getWorldObj().blockExists(i, 64, j)) {
            double d = 0.66;
            int k = MathHelper.floor_double((double)(this.yCoord + d));
            return this.container.getWorldObj().getLightBrightness(i, k, j);
        }
        return 0.0f;
    }

    public boolean isCorrupted() {
        return this.itemStack == null || this.itemStack.stackSize <= 0 || this.itemStack.getItem() == null;
    }

    public boolean canBeGroupedWith(TravelingItem otherItem) {
        if (otherItem == this) {
            return false;
        }
        if (this.toCenter != otherItem.toCenter) {
            return false;
        }
        if (this.output != otherItem.output) {
            return false;
        }
        if (this.color != otherItem.color) {
            return false;
        }
        if (this.hasExtraData() || otherItem.hasExtraData()) {
            return false;
        }
        if (this.insertionHandler != DEFAULT_INSERTION_HANDLER) {
            return false;
        }
        if (!this.blacklist.equals(otherItem.blacklist)) {
            return false;
        }
        if (otherItem.isCorrupted()) {
            return false;
        }
        return StackHelper.canStacksMerge(this.itemStack, otherItem.itemStack);
    }

    public boolean tryMergeInto(TravelingItem otherItem) {
        if (!this.canBeGroupedWith(otherItem)) {
            return false;
        }
        if (StackHelper.mergeStacks(this.itemStack, otherItem.itemStack, false) == this.itemStack.stackSize) {
            StackHelper.mergeStacks(this.itemStack, otherItem.itemStack, true);
            this.itemStack.stackSize = 0;
            return true;
        }
        return false;
    }

    public boolean ignoreWeight() {
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TravelingItem other = (TravelingItem)obj;
        return this.id == other.id;
    }

    public void cleanup() {
        if (this.hasDisplayList) {
            TransportProxy.proxy.clearDisplayList(this.displayList);
            this.hasDisplayList = false;
        }
    }

    public String toString() {
        return "TravelingItem: " + this.id;
    }

    public static class TravelingItemCache {
        private final Map<Integer, TravelingItem> itemCache = new MapMaker().weakValues().makeMap();

        public void cache(TravelingItem item) {
            this.itemCache.put(item.id, item);
        }

        public TravelingItem get(int id) {
            return this.itemCache.get(id);
        }
    }

    public static class InsertionHandler {
        public boolean canInsertItem(TravelingItem item, IInventory inv) {
            return true;
        }
    }
}

