/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.gates.GatePluggable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemGate
extends ItemBuildCraft
implements IPipePluggableItem {
    protected static final String NBT_TAG_MAT = "mat";
    protected static final String NBT_TAG_LOGIC = "logic";
    protected static final String NBT_TAG_EX = "ex";
    private static ArrayList<ItemStack> allGates;

    public ItemGate() {
        this.setHasSubtypes(false);
        this.setMaxDamage(0);
        this.setPassSneakClick(true);
        this.setCreativeTab(BCCreativeTab.get("gates"));
    }

    private static NBTTagCompound getNBT(ItemStack stack) {
        if (stack == null || !(stack.getItem() instanceof ItemGate)) {
            return null;
        }
        return InvUtils.getItemData(stack);
    }

    public static void setMaterial(ItemStack stack, GateDefinition.GateMaterial material) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.setByte(NBT_TAG_MAT, (byte)material.ordinal());
    }

    public static GateDefinition.GateMaterial getMaterial(ItemStack stack) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return GateDefinition.GateMaterial.REDSTONE;
        }
        return GateDefinition.GateMaterial.fromOrdinal(nbt.getByte(NBT_TAG_MAT));
    }

    public static GateDefinition.GateLogic getLogic(ItemStack stack) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return GateDefinition.GateLogic.AND;
        }
        return GateDefinition.GateLogic.fromOrdinal(nbt.getByte(NBT_TAG_LOGIC));
    }

    public static void setLogic(ItemStack stack, GateDefinition.GateLogic logic) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.setByte(NBT_TAG_LOGIC, (byte)logic.ordinal());
    }

    public static void addGateExpansion(ItemStack stack, IGateExpansion expansion) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return;
        }
        NBTTagList expansionList = nbt.getTagList(NBT_TAG_EX, 8);
        expansionList.appendTag((NBTBase)new NBTTagString(expansion.getUniqueIdentifier()));
        nbt.setTag(NBT_TAG_EX, (NBTBase)expansionList);
    }

    public static boolean hasGateExpansion(ItemStack stack, IGateExpansion expansion) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return false;
        }
        try {
            NBTTagList expansionList = nbt.getTagList(NBT_TAG_EX, 8);
            for (int i = 0; i < expansionList.tagCount(); ++i) {
                String ex = expansionList.getStringTagAt(i);
                if (!ex.equals(expansion.getUniqueIdentifier())) continue;
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    public static Set<IGateExpansion> getInstalledExpansions(ItemStack stack) {
        HashSet<IGateExpansion> expansions = new HashSet<IGateExpansion>();
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return expansions;
        }
        try {
            NBTTagList expansionList = nbt.getTagList(NBT_TAG_EX, 8);
            for (int i = 0; i < expansionList.tagCount(); ++i) {
                String exTag = expansionList.getStringTagAt(i);
                IGateExpansion ex = GateExpansions.getExpansion(exTag);
                if (ex == null) continue;
                expansions.add(ex);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return expansions;
    }

    public static ItemStack makeGateItem(GateDefinition.GateMaterial material, GateDefinition.GateLogic logic) {
        ItemStack stack = new ItemStack(BuildCraftTransport.pipeGate);
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.setByte(NBT_TAG_MAT, (byte)material.ordinal());
        nbt.setByte(NBT_TAG_LOGIC, (byte)logic.ordinal());
        return stack;
    }

    public static ItemStack makeGateItem(Gate gate) {
        ItemStack stack = new ItemStack(BuildCraftTransport.pipeGate);
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.setByte(NBT_TAG_MAT, (byte)gate.material.ordinal());
        nbt.setByte(NBT_TAG_LOGIC, (byte)gate.logic.ordinal());
        for (IGateExpansion expansion : gate.expansions.keySet()) {
            ItemGate.addGateExpansion(stack, expansion);
        }
        return stack;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return GateDefinition.getLocalizedName(ItemGate.getMaterial(stack), ItemGate.getLogic(stack));
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return ("" + StatCollector.translateToLocal((String)this.getUnlocalizedNameInefficiently(stack))).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        for (GateDefinition.GateMaterial material : GateDefinition.GateMaterial.VALUES) {
            for (GateDefinition.GateLogic logic : GateDefinition.GateLogic.VALUES) {
                if (material == GateDefinition.GateMaterial.REDSTONE && logic == GateDefinition.GateLogic.OR) continue;
                itemList.add(ItemGate.makeGateItem(material, logic));
                for (IGateExpansion exp : GateExpansions.getExpansions()) {
                    ItemStack stackExpansion = ItemGate.makeGateItem(material, logic);
                    ItemGate.addGateExpansion(stackExpansion, exp);
                    itemList.add(stackExpansion);
                }
            }
        }
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        super.addInformation(stack, player, list, adv);
        list.add(StringUtils.localize("tip.gate.wires"));
        list.add(StringUtils.localize("tip.gate.wires." + ItemGate.getMaterial(stack).getTag()));
        Set<IGateExpansion> expansions = ItemGate.getInstalledExpansions(stack);
        if (!expansions.isEmpty()) {
            list.add(StringUtils.localize("tip.gate.expansions"));
            for (IGateExpansion expansion : expansions) {
                list.add(expansion.getDisplayName());
            }
        }
    }

    public IIcon getIconIndex(ItemStack stack) {
        return ItemGate.getLogic(stack).getIconItem();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        for (GateDefinition.GateMaterial gateMaterial : GateDefinition.GateMaterial.VALUES) {
            gateMaterial.registerItemIcon(iconRegister);
        }
        for (Enum enum_ : GateDefinition.GateLogic.VALUES) {
            ((GateDefinition.GateLogic)enum_).registerItemIcon(iconRegister);
        }
        for (IGateExpansion expansion : GateExpansions.getExpansions()) {
            expansion.registerItemOverlay(iconRegister);
        }
    }

    @Override
    public PipePluggable createPipePluggable(IPipe pipe, ForgeDirection side, ItemStack stack) {
        Pipe realPipe = (Pipe)pipe;
        return new GatePluggable(GateFactory.makeGate(realPipe, stack, side));
    }

    public static ArrayList<ItemStack> getAllGates() {
        if (allGates == null) {
            allGates = new ArrayList();
            for (GateDefinition.GateMaterial m : GateDefinition.GateMaterial.VALUES) {
                for (GateDefinition.GateLogic l : GateDefinition.GateLogic.VALUES) {
                    if (m == GateDefinition.GateMaterial.REDSTONE && l == GateDefinition.GateLogic.OR) continue;
                    allGates.add(ItemGate.makeGateItem(m, l));
                }
            }
        }
        return allGates;
    }
}

