/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.slots.SlotPhantom;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.gui.widgets.ButtonWidget;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.utils.RevolvingList;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEmzuliPipe
extends BuildCraftContainer {
    private final PipeItemsEmzuli pipe;
    private final IInventory filterInv;
    private final byte[] prevSlotColors = new byte[4];
    private final PaintWidget[] paintWidgets = new PaintWidget[4];

    public ContainerEmzuliPipe(IInventory playerInventory, PipeItemsEmzuli pipe) {
        super(pipe.getFilters().getSizeInventory());
        this.pipe = pipe;
        this.filterInv = pipe.getFilters();
        this.paintWidgets[0] = new PaintWidget(0, 51, 19);
        this.addWidget(this.paintWidgets[0]);
        this.paintWidgets[1] = new PaintWidget(1, 104, 19);
        this.addWidget(this.paintWidgets[1]);
        this.paintWidgets[2] = new PaintWidget(2, 51, 47);
        this.addWidget(this.paintWidgets[2]);
        this.paintWidgets[3] = new PaintWidget(3, 104, 47);
        this.addWidget(this.paintWidgets[3]);
        this.addSlot(new SlotPhantom(this.filterInv, 0, 25, 21));
        this.addSlot(new SlotPhantom(this.filterInv, 1, 134, 21));
        this.addSlot(new SlotPhantom(this.filterInv, 2, 25, 49));
        this.addSlot(new SlotPhantom(this.filterInv, 3, 134, 49));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlotToContainer(new Slot(playerInventory, k1 + l * 9 + 9, 8 + k1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot(playerInventory, i1, 8 + i1 * 18, 142));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting player) {
        super.addCraftingToCrafters(player);
        for (int slot = 0; slot < this.pipe.slotColors.length; ++slot) {
            this.prevSlotColors[slot] = this.pipe.slotColors[slot];
            player.sendProgressBarUpdate((Container)this, slot, (int)this.pipe.slotColors[slot]);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            ICrafting player = (ICrafting)crafter;
            for (int slot = 0; slot < this.pipe.slotColors.length; ++slot) {
                if (this.prevSlotColors[slot] == this.pipe.slotColors[slot]) continue;
                player.sendProgressBarUpdate((Container)this, slot, (int)this.pipe.slotColors[slot]);
            }
        }
        System.arraycopy(this.pipe.slotColors, 0, this.prevSlotColors, 0, this.pipe.slotColors.length);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        this.paintWidgets[id].colors.setCurrent(data == 0 ? null : EnumColor.fromId(data - 1));
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.pipe.container.isUseableByPlayer(entityplayer);
    }

    private class PaintWidget
    extends ButtonWidget {
        private final int slot;
        private RevolvingList<EnumColor> colors;
        private ToolTip toolTip;

        public PaintWidget(int slot, int x, int y) {
            super(x, y, 176, 0, 20, 20);
            this.colors = new RevolvingList();
            this.toolTip = new ToolTip(500, new ToolTipLine[0]){

                @Override
                public void refresh() {
                    PaintWidget.this.toolTip.clear();
                    EnumColor color = (EnumColor)((Object)PaintWidget.this.colors.getCurrent());
                    if (color != null) {
                        PaintWidget.this.toolTip.add(new ToolTipLine(String.format(StringUtils.localize("gui.pipes.emzuli.paint"), color.getLocalizedName())));
                    } else {
                        PaintWidget.this.toolTip.add(new ToolTipLine(StringUtils.localize("gui.pipes.emzuli.nopaint")));
                    }
                }
            };
            this.slot = slot;
            this.colors.add(null);
            this.colors.addAll(Arrays.asList(EnumColor.VALUES));
        }

        @Override
        public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
            super.draw(gui, guiX, guiY, mouseX, mouseY);
            EnumColor color = this.colors.getCurrent();
            if (color != null) {
                gui.bindTexture(TextureMap.locationItemsTexture);
                gui.drawTexturedModelRectFromIcon(guiX + this.x + 2, guiY + this.y + 2, BuildCraftTransport.actionPipeColor[color.ordinal()].getIcon(), 16, 16);
            } else {
                gui.drawTexturedModalRect(guiX + this.x + 2, guiY + this.y + 2, this.u, this.v + this.h + this.h, 16, 16);
            }
        }

        @Override
        public void onRelease(int mouseButton) {
            switch (mouseButton) {
                case 0: {
                    this.colors.rotateLeft();
                    break;
                }
                case 1: {
                    this.colors.rotateRight();
                    break;
                }
                case 2: {
                    this.colors.setCurrent(null);
                }
            }
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream data = new DataOutputStream(bytes);
                data.writeByte(this.slot);
                EnumColor color = this.colors.getCurrent();
                data.writeByte(color == null ? 0 : color.ordinal() + 1);
                PacketGuiReturn pkt = new PacketGuiReturn(ContainerEmzuliPipe.this.pipe.getContainer(), bytes.toByteArray());
                pkt.sendPacket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public ToolTip getToolTip() {
            return this.toolTip;
        }
    }
}

