/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.buttons.GuiImageButton;
import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.gui.ContainerEmeraldPipe;
import buildcraft.transport.pipes.PipeItemsEmerald;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiEmeraldPipe
extends GuiBuildCraft
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald.png");
    private static final ResourceLocation TEXTURE_BUTTON = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald_button.png");
    private static final int WHITE_LIST_BUTTON_ID = 1;
    private static final int BLACK_LIST_BUTTON_ID = 2;
    private static final int ROUND_ROBIN_BUTTON_ID = 3;
    private GuiImageButton whiteListButton;
    private GuiImageButton blackListButton;
    private GuiImageButton roundRobinButton;
    private PipeItemsEmerald pipe;

    public GuiEmeraldPipe(IInventory playerInventory, PipeItemsEmerald pipe) {
        super(new ContainerEmeraldPipe(playerInventory, pipe), pipe.getFilters(), TEXTURE);
        this.pipe = pipe;
        this.xSize = 175;
        this.ySize = 161;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.whiteListButton = new GuiImageButton(1, this.guiLeft + 7, this.guiTop + 41, 18, TEXTURE_BUTTON, 19, 19);
        this.whiteListButton.registerListener(this);
        this.whiteListButton.setToolTip(new ToolTip(500, new ToolTipLine(StatCollector.translateToLocal((String)"tip.PipeItemsEmerald.whitelist"))));
        this.buttonList.add(this.whiteListButton);
        this.blackListButton = new GuiImageButton(2, this.guiLeft + 7 + 18, this.guiTop + 41, 18, TEXTURE_BUTTON, 37, 19);
        this.blackListButton.registerListener(this);
        this.blackListButton.setToolTip(new ToolTip(500, new ToolTipLine(StatCollector.translateToLocal((String)"tip.PipeItemsEmerald.blacklist"))));
        this.buttonList.add(this.blackListButton);
        this.roundRobinButton = new GuiImageButton(3, this.guiLeft + 7 + 36, this.guiTop + 41, 18, TEXTURE_BUTTON, 55, 19);
        this.roundRobinButton.registerListener(this);
        this.roundRobinButton.setToolTip(new ToolTip(500, new ToolTipLine(StatCollector.translateToLocal((String)"tip.PipeItemsEmerald.roundrobin"))));
        this.buttonList.add(this.roundRobinButton);
        switch (this.pipe.getSettings().getFilterMode()) {
            case WHITE_LIST: {
                this.whiteListButton.activate();
                break;
            }
            case BLACK_LIST: {
                this.blackListButton.activate();
                break;
            }
            case ROUND_ROBIN: {
                this.roundRobinButton.activate();
            }
        }
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger sender, int buttonId) {
        switch (buttonId) {
            case 1: {
                this.whiteListButton.activate();
                this.blackListButton.deActivate();
                this.roundRobinButton.deActivate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.WHITE_LIST);
                break;
            }
            case 2: {
                this.whiteListButton.deActivate();
                this.blackListButton.activate();
                this.roundRobinButton.deActivate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.BLACK_LIST);
                break;
            }
            case 3: {
                this.whiteListButton.deActivate();
                this.blackListButton.deActivate();
                this.roundRobinButton.activate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.ROUND_ROBIN);
            }
        }
        if (this.pipe.getWorld().isRemote) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.pipe.getContainer());
            pkt.sendPacket();
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String title = StringUtils.localize("gui.pipes.emerald.title");
        this.fontRendererObj.drawString(title, (this.xSize - this.fontRendererObj.getStringWidth(title)) / 2, 6, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 93, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }
}

