/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.transport.IPipe;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.StatementParameterSlot;
import buildcraft.core.lib.gui.StatementSlot;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.ActionActiveState;
import buildcraft.transport.Gate;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gui.ContainerGateInterface;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGateInterface
extends GuiAdvancedInterface {
    IInventory playerInventory;
    private final ContainerGateInterface container;
    private final GuiGateInterface instance;
    private final IPipe pipe;
    private Gate gate;

    public GuiGateInterface(IInventory playerInventory, IPipe pipe) {
        super(new ContainerGateInterface(playerInventory, pipe), null, null);
        this.container = (ContainerGateInterface)this.inventorySlots;
        this.container.gateCallback = this;
        this.pipe = pipe;
        this.playerInventory = playerInventory;
        this.instance = this;
    }

    public void setGate(Gate gate) {
        this.gate = gate;
        this.init();
    }

    public void init() {
        if (this.gate == null) {
            return;
        }
        this.xSize = 176;
        this.ySize = this.gate.material.guiHeight;
        int position = 0;
        this.slots.clear();
        if (this.gate.material == GateDefinition.GateMaterial.REDSTONE) {
            this.slots.add(new TriggerSlot(62, 26, this.pipe, 0));
            this.slots.add(new ActionSlot(98, 26, this.pipe, 0));
        } else if (this.gate.material == GateDefinition.GateMaterial.IRON) {
            this.slots.add(new TriggerSlot(62, 26, this.pipe, 0));
            this.slots.add(new TriggerSlot(62, 44, this.pipe, 1));
            this.slots.add(new ActionSlot(98, 26, this.pipe, 0));
            this.slots.add(new ActionSlot(98, 44, this.pipe, 1));
        } else if (this.gate.material == GateDefinition.GateMaterial.QUARTZ) {
            for (int i = 0; i < 2; ++i) {
                TriggerSlot ts = new TriggerSlot(44, 26 + i * 18, this.pipe, i);
                ActionSlot as = new ActionSlot(98, 26 + i * 18, this.pipe, i);
                this.slots.add(ts);
                this.slots.add(as);
                this.slots.add(new TriggerParameterSlot(62, 26 + i * 18, this.pipe, 0, ts));
                this.slots.add(new ActionParameterSlot(116, 26 + i * 18, this.pipe, 0, as));
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.GOLD) {
            int k;
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerSlot(53, 26 + 18 * k, this.pipe, position));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new ActionSlot(107, 26 + 18 * k, this.pipe, position - 4));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerParameterSlot(71, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(k)));
                ++position;
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.DIAMOND) {
            int k;
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerSlot(8, 26 + 18 * k, this.pipe, position));
                this.slots.add(new TriggerSlot(98, 26 + 18 * k, this.pipe, ++position));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new ActionSlot(62, 26 + 18 * k, this.pipe, position - 8));
                this.slots.add(new ActionSlot(152, 26 + 18 * k, this.pipe, ++position - 8));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerParameterSlot(26, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(position - 16)));
                this.slots.add(new TriggerParameterSlot(116, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(++position - 16)));
                ++position;
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.EMERALD) {
            for (int y = 0; y < 4; ++y) {
                int x;
                this.slots.add(new TriggerSlot(8, 26 + 18 * y, this.pipe, y));
                int lastPos = position++;
                for (x = 0; x < 3; ++x) {
                    this.slots.add(new TriggerParameterSlot(8 + 18 * (x + 1), 26 + 18 * y, this.pipe, x, (TriggerSlot)this.slots.get(lastPos)));
                    ++position;
                }
                this.slots.add(new ActionSlot(98, 26 + 18 * y, this.pipe, y));
                lastPos = position++;
                for (x = 0; x < 3; ++x) {
                    this.slots.add(new ActionParameterSlot(98 + 18 * (x + 1), 26 + 18 * y, this.pipe, x, (ActionSlot)this.slots.get(lastPos)));
                    ++position;
                }
            }
        }
        this.initGui();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        if (this.gate == null) {
            return;
        }
        String name = this.container.getGateName();
        this.fontRendererObj.drawString(name, this.getCenteredOffset(name), 10, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 97, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        this.container.synchronize();
        if (this.gate == null) {
            return;
        }
        ResourceLocation texture = this.container.getGateGuiFile();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (AdvancedSlot slot : this.slots) {
            if (slot instanceof TriggerSlot) {
                boolean halfWidth;
                boolean bl = halfWidth = this.container.actionsState[((TriggerSlot)slot).slot] == ActionActiveState.Partial;
                if (this.container.actionsState[((TriggerSlot)slot).slot] == ActionActiveState.Deactivated) continue;
                this.mc.renderEngine.bindTexture(texture);
                this.drawTexturedModalRect(this.guiLeft + slot.x + 17 + 18 * this.gate.material.numTriggerParameters, this.guiTop + slot.y + 6, 176, 18, halfWidth ? 9 : 18, 4);
                continue;
            }
            if (!(slot instanceof StatementParameterSlot)) continue;
            StatementParameterSlot paramSlot = (StatementParameterSlot)slot;
            StatementSlot statement = paramSlot.statementSlot;
            this.mc.renderEngine.bindTexture(texture);
            if (statement.isDefined()) {
                if (!paramSlot.isAllowed()) {
                    this.drawTexturedModalRect(this.guiLeft + slot.x - 1, this.guiTop + slot.y - 1, 176, 0, 18, 18);
                    continue;
                }
                if (!paramSlot.isRequired() || paramSlot.getItemStack() != null) continue;
                this.drawTexturedModalRect(this.guiLeft + slot.x - 1, this.guiTop + slot.y - 1, 176, 22, 18, 18);
                continue;
            }
            this.drawTexturedModalRect(this.guiLeft + slot.x - 1, this.guiTop + slot.y - 1, 176, 0, 18, 18);
        }
        this.drawBackgroundSlots(x, y);
    }

    private void doSlotClick(AdvancedSlot slot, int k) {
        if (slot instanceof TriggerSlot && this.container.hasTriggers()) {
            TriggerSlot triggerSlot = (TriggerSlot)slot;
            IStatement changed = null;
            if (GuiGateInterface.isShiftKeyDown()) {
                changed = null;
            } else if (triggerSlot.getStatement() == null) {
                changed = k == 0 ? this.container.getFirstTrigger() : this.container.getLastTrigger();
            } else {
                Iterator<IStatement> it = this.container.getTriggerIterator(k != 0);
                while (it.hasNext()) {
                    IStatement trigger = it.next();
                    if (!it.hasNext()) {
                        changed = null;
                        break;
                    }
                    if (trigger != triggerSlot.getStatement()) continue;
                    changed = it.next();
                    break;
                }
            }
            if (changed == null) {
                this.container.setTrigger(triggerSlot.slot, null, true);
            } else {
                this.container.setTrigger(triggerSlot.slot, changed.getUniqueTag(), true);
            }
            for (StatementParameterSlot p : triggerSlot.parameters) {
                IStatementParameter parameter = null;
                if (changed != null && p.slot < changed.minParameters()) {
                    parameter = changed.createParameter(p.slot);
                }
                this.container.setTriggerParameter(triggerSlot.slot, p.slot, parameter, true);
            }
        } else if (slot instanceof ActionSlot) {
            ActionSlot actionSlot = (ActionSlot)slot;
            IStatement changed = null;
            if (GuiGateInterface.isShiftKeyDown()) {
                changed = null;
            } else if (actionSlot.getStatement() == null) {
                changed = k == 0 ? this.container.getFirstAction() : this.container.getLastAction();
            } else {
                Iterator<IStatement> it = this.container.getActionIterator(k != 0);
                while (it.hasNext()) {
                    IStatement action = it.next();
                    if (!it.hasNext()) {
                        changed = null;
                        break;
                    }
                    if (action != actionSlot.getStatement()) continue;
                    changed = it.next();
                    break;
                }
            }
            if (changed == null) {
                this.container.setAction(actionSlot.slot, null, true);
            } else {
                this.container.setAction(actionSlot.slot, changed.getUniqueTag(), true);
            }
            for (StatementParameterSlot p : actionSlot.parameters) {
                IStatementParameter parameter = null;
                if (changed != null && p.slot < changed.minParameters()) {
                    parameter = changed.createParameter(p.slot);
                }
                this.container.setActionParameter(actionSlot.slot, p.slot, parameter, true);
            }
        } else if (slot instanceof StatementParameterSlot) {
            StatementParameterSlot paramSlot = (StatementParameterSlot)slot;
            StatementSlot statement = paramSlot.statementSlot;
            if (statement.isDefined() && statement.getStatement().maxParameters() != 0) {
                IStatementParameter param = paramSlot.getParameter();
                if (param == null) {
                    param = statement.getStatement().createParameter(paramSlot.slot);
                }
                if (param != null) {
                    param.onClick(this.gate, statement.getStatement(), this.mc.thePlayer.inventory.getItemStack(), new StatementMouseClick(k, GuiGateInterface.isShiftKeyDown()));
                    paramSlot.setParameter(param, true);
                }
            }
        }
        this.container.markDirty();
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        if (this.gate == null) {
            return;
        }
        super.mouseClicked(i, j, k);
        AdvancedSlot slot = this.getSlotAtLocation(i, j);
        if (slot != null) {
            this.doSlotClick(slot, k);
        }
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            int i = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int j = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.doSlotClick(this.getSlotAtLocation(i, j), wheel > 0 ? 0 : 1);
        }
    }

    class ActionParameterSlot
    extends StatementParameterSlot {
        public ActionParameterSlot(int x, int y, IPipe pipe, int slot, StatementSlot iStatementSlot) {
            super(GuiGateInterface.this.instance, x, y, slot, iStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            return GuiGateInterface.this.gate.getActionParameter(this.statementSlot.slot, this.slot);
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
            GuiGateInterface.this.container.setActionParameter(this.statementSlot.slot, this.slot, param, notifyServer);
        }
    }

    class TriggerParameterSlot
    extends StatementParameterSlot {
        public TriggerParameterSlot(int x, int y, IPipe pipe, int slot, StatementSlot iStatementSlot) {
            super(GuiGateInterface.this.instance, x, y, slot, iStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            return GuiGateInterface.this.gate.getTriggerParameter(this.statementSlot.slot, this.slot);
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
            GuiGateInterface.this.container.setTriggerParameter(this.statementSlot.slot, this.slot, param, notifyServer);
        }
    }

    private class ActionSlot
    extends StatementSlot {
        public ActionSlot(int x, int y, IPipe pipe, int slot) {
            super(GuiGateInterface.this.instance, x, y, slot);
        }

        @Override
        public IStatement getStatement() {
            return GuiGateInterface.this.gate.getAction(this.slot);
        }
    }

    private class TriggerSlot
    extends StatementSlot {
        public TriggerSlot(int x, int y, IPipe pipe, int slot) {
            super(GuiGateInterface.this.instance, x, y, slot);
        }

        @Override
        public IStatement getStatement() {
            return GuiGateInterface.this.gate.getTrigger(this.slot);
        }
    }
}

