/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketHandler;
import buildcraft.core.lib.network.PacketSlotChange;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPipeTransportItemStackRequest;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandlerTransport
extends PacketHandler {
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
        super.channelRead0(ctx, packet);
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 4: {
                    this.onPacketPower(player, (PacketPowerUpdate)packet);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    this.onPipeTravelerUpdate(player, (PacketPipeTransportTraveler)packet);
                    break;
                }
                case 6: {
                    break;
                }
                case 31: {
                    this.onDiamondPipeSelect(player, (PacketSlotChange)packet);
                    break;
                }
                case 32: {
                    this.onEmeraldPipeSelect(player, (PacketSlotChange)packet);
                    break;
                }
                case 5: {
                    ((PacketPipeTransportItemStackRequest)packet).sendDataToPlayer(player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onPipeTravelerUpdate(EntityPlayer player, PacketPipeTransportTraveler packet) {
        World world = player.worldObj;
        if (!world.blockExists(packet.posX, packet.posY, packet.posZ)) {
            return;
        }
        TileEntity entity = world.getTileEntity(packet.posX, packet.posY, packet.posZ);
        if (!(entity instanceof IPipeTile)) {
            return;
        }
        IPipeTile pipe = (IPipeTile)entity;
        if (pipe.getPipe() == null) {
            return;
        }
        if (!(((Pipe)pipe.getPipe()).transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)((Pipe)pipe.getPipe()).transport).handleTravelerPacket(packet);
    }

    private void onPacketPower(EntityPlayer player, PacketPowerUpdate packetPower) {
        World world = player.worldObj;
        if (!world.blockExists(packetPower.posX, packetPower.posY, packetPower.posZ)) {
            return;
        }
        TileEntity entity = world.getTileEntity(packetPower.posX, packetPower.posY, packetPower.posZ);
        if (!(entity instanceof IPipeTile)) {
            return;
        }
        IPipeTile pipe = (IPipeTile)entity;
        if (pipe.getPipe() == null) {
            return;
        }
        if (!(((Pipe)pipe.getPipe()).transport instanceof PipeTransportPower)) {
            return;
        }
        ((PipeTransportPower)((Pipe)pipe.getPipe()).transport).handlePowerPacket(packetPower);
    }

    private TileGenericPipe getPipe(World world, int x, int y, int z) {
        if (!world.blockExists(x, y, z)) {
            return null;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }

    private void onDiamondPipeSelect(EntityPlayer player, PacketSlotChange packet) {
        TileGenericPipe pipe = this.getPipe(player.worldObj, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeItemsDiamond)) {
            return;
        }
        ((PipeItemsDiamond)pipe.pipe).getFilters().setInventorySlotContents(packet.slot, packet.stack);
    }

    private void onEmeraldPipeSelect(EntityPlayer player, PacketSlotChange packet) {
        TileGenericPipe pipe = this.getPipe(player.worldObj, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeItemsEmerald)) {
            return;
        }
        ((PipeItemsEmerald)pipe.pipe).getFilters().setInventorySlotContents(packet.slot, packet.stack);
    }
}

