/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.pipes.events.PipeEventPriority;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsClay
extends Pipe<PipeTransportItems> {
    public PipeItemsClay(Item item) {
        super(new PipeTransportItems(), item);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.PipeItemsClay.ordinal();
    }

    @PipeEventPriority(priority=-200)
    public void eventHandler(PipeEventItem.FindDest event) {
        LinkedList<ForgeDirection> nonPipesList = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> pipesList = new LinkedList<ForgeDirection>();
        for (ForgeDirection o : event.destinations) {
            if (event.item.blacklist.contains(o) || !this.container.pipe.outputOpen(o) || !this.container.isPipeConnected(o)) continue;
            TileEntity entity = this.container.getTile(o);
            if (entity instanceof IPipeTile) {
                pipesList.add(o);
                continue;
            }
            nonPipesList.add(o);
        }
        event.destinations.clear();
        if (nonPipesList.isEmpty()) {
            event.destinations.addAll(pipesList);
        } else {
            event.destinations.addAll(nonPipesList);
        }
    }
}

