/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.recipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.JavaTools;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.recipes.IntegrationRecipeBC;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemPipeWire;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AdvancedFacadeRecipe
extends IntegrationRecipeBC {
    public AdvancedFacadeRecipe() {
        super(25000, 2);
    }

    @Override
    public List<ItemStack> generateExampleInput() {
        return ItemFacade.allFacades;
    }

    @Override
    public List<ItemStack> generateExampleOutput() {
        return ItemFacade.allFacades;
    }

    @Override
    public List<List<ItemStack>> generateExampleExpansions() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        list.add(ItemFacade.allFacades);
        ArrayList<ItemStack> pipeWires = new ArrayList<ItemStack>();
        for (PipeWire wire : PipeWire.values()) {
            pipeWires.add(wire.getStack());
        }
        list.add(pipeWires);
        return list;
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return input.getItem() instanceof ItemFacade;
    }

    @Override
    public boolean isValidExpansion(ItemStack input, ItemStack expansion) {
        return expansion.getItem() instanceof ItemFacade && ((IFacadeItem)expansion.getItem()).getFacadeType(expansion) == FacadeType.Basic || expansion.getItem() == BuildCraftTransport.plugItem || expansion.getItem() == BuildCraftTransport.pipeWire;
    }

    @Override
    public ItemStack craft(ItemStack input, List<ItemStack> expansions, boolean preview) {
        PipeWire wire = null;
        ItemStack facade = null;
        for (ItemStack stack : expansions) {
            if (wire == null && stack.getItem() instanceof ItemPipeWire) {
                wire = PipeWire.fromOrdinal(stack.getItemDamage());
                if (preview) continue;
                --stack.stackSize;
                continue;
            }
            if (facade != null || !(stack.getItem() instanceof ItemFacade) && stack.getItem() != BuildCraftTransport.pipeWire) continue;
            facade = stack;
            if (preview) continue;
            --stack.stackSize;
        }
        if (wire != null && facade != null) {
            ItemFacade.FacadeState additionalState;
            ItemFacade.FacadeState[] states = ItemFacade.getFacadeStates(input);
            if (facade.getItem() == BuildCraftTransport.plugItem) {
                additionalState = ItemFacade.FacadeState.createTransparent(wire);
            } else {
                additionalState = ItemFacade.getFacadeStates(facade)[0];
                additionalState = new ItemFacade.FacadeState(additionalState.block, additionalState.metadata, wire, additionalState.hollow);
            }
            for (int i = 0; i < states.length; ++i) {
                if (states[i].wire != wire) continue;
                states[i] = additionalState;
                return ItemFacade.getFacade(states);
            }
            return ItemFacade.getFacade(JavaTools.concat(states, new ItemFacade.FacadeState[]{additionalState}));
        }
        return null;
    }
}

