/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IFacadePluggable;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.CompatHooks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class FacadeBlockAccess
implements IBlockAccess {
    private final IBlockAccess world;
    private final ForgeDirection side;

    public FacadeBlockAccess(IBlockAccess world, ForgeDirection side) {
        this.world = world;
        this.side = side;
    }

    public Block getBlock(int x, int y, int z) {
        PipePluggable p;
        Block compatBlock = CompatHooks.INSTANCE.getVisualBlock(this.world, x, y, z, this.side);
        if (compatBlock != null) {
            return compatBlock;
        }
        TileEntity tile = this.world.getTileEntity(x, y, z);
        if (tile instanceof IPipeTile && (p = ((IPipeTile)tile).getPipePluggable(this.side)) instanceof IFacadePluggable) {
            return ((IFacadePluggable)((Object)p)).getCurrentBlock();
        }
        return Blocks.air;
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        return null;
    }

    public int getLightBrightnessForSkyBlocks(int x, int y, int z, int a) {
        return 0;
    }

    public int getBlockMetadata(int x, int y, int z) {
        PipePluggable p;
        int compatMeta = CompatHooks.INSTANCE.getVisualMeta(this.world, x, y, z, this.side);
        if (compatMeta >= 0) {
            return compatMeta;
        }
        TileEntity tile = this.world.getTileEntity(x, y, z);
        if (tile instanceof IPipeTile && (p = ((IPipeTile)tile).getPipePluggable(this.side)) instanceof IFacadePluggable) {
            return ((IFacadePluggable)((Object)p)).getCurrentMetadata();
        }
        return 0;
    }

    public int isBlockProvidingPowerTo(int x, int y, int z, int side) {
        return 0;
    }

    public boolean isAirBlock(int x, int y, int z) {
        return !(this.world.getTileEntity(x, y, z) instanceof IPipeTile);
    }

    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        return this.world.getBiomeGenForCoords(x, z);
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    public boolean extendedLevelsInChunkCache() {
        return this.world.extendedLevelsInChunkCache();
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean def) {
        return this.world.isSideSolid(x, y, z, side, def);
    }
}

