/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.gates.IGateExpansion;
import buildcraft.transport.gates.ItemGate;
import java.util.Random;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class GateItemRenderer
implements IItemRenderer {
    RenderItem renderItem = new RenderItem();

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.render(IItemRenderer.ItemRenderType.INVENTORY, stack);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (RenderManager.instance.options.fancyGraphics) {
                this.renderAsEntity(stack, (EntityItem)data[1]);
            } else {
                this.renderAsEntityFlat(stack);
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderIn3D(stack);
        }
    }

    private void renderIn3D(ItemStack stack) {
        GL11.glPushMatrix();
        this.renderLayerIn3D(ItemGate.getLogic(stack).getIconItem());
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.05f);
        this.renderLayerIn3D(ItemGate.getMaterial(stack).getIconItem());
        for (IGateExpansion expansion : ItemGate.getInstalledExpansions(stack)) {
            this.renderLayerIn3D(expansion.getOverlayItem());
        }
        GL11.glPopMatrix();
    }

    private void renderLayerIn3D(IIcon icon) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.instance;
        float uv1 = icon.getMinU();
        float uv2 = icon.getMaxU();
        float uv3 = icon.getMinV();
        float uv4 = icon.getMaxV();
        ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)uv2, (float)uv3, (float)uv1, (float)uv4, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
        GL11.glPopMatrix();
    }

    private void renderAsEntity(ItemStack stack, EntityItem entity) {
        GL11.glPushMatrix();
        int iterations = 1;
        if (stack.stackSize > 1) {
            iterations = 2;
        }
        if (stack.stackSize > 15) {
            iterations = 3;
        }
        if (stack.stackSize > 31) {
            iterations = 4;
        }
        Random rand = new Random(187L);
        float offsetZ = 0.084375f;
        GL11.glRotatef((float)((((float)entity.age + 1.0f) / 20.0f + entity.hoverStart) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)(-(offsetZ * (float)iterations / 2.0f)));
        for (int count = 0; count < iterations; ++count) {
            if (count > 0) {
                float offsetX = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                float offsetY = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)offsetZ);
            }
            this.renderIn3D(stack);
        }
        GL11.glPopMatrix();
    }

    private void renderAsEntityFlat(ItemStack stack) {
        GL11.glPushMatrix();
        int iterations = 1;
        if (stack.stackSize > 1) {
            iterations = 2;
        }
        if (stack.stackSize > 15) {
            iterations = 3;
        }
        if (stack.stackSize > 31) {
            iterations = 4;
        }
        Random rand = new Random(187L);
        for (int ii = 0; ii < iterations; ++ii) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f - RenderManager.instance.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            if (ii > 0) {
                float var12 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var13 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var14 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                GL11.glTranslatef((float)var12, (float)var13, (float)var14);
            }
            GL11.glTranslatef((float)0.5f, (float)0.8f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
            this.render(IItemRenderer.ItemRenderType.ENTITY, stack);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void render(IItemRenderer.ItemRenderType type, ItemStack stack) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        IIcon icon = ItemGate.getLogic(stack).getIconItem();
        this.renderItem.renderIcon(0, 0, icon, 16, 16);
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
        }
        if ((icon = ItemGate.getMaterial(stack).getIconItem()) != null) {
            this.renderItem.renderIcon(0, 0, icon, 16, 16);
        }
        for (IGateExpansion expansion : ItemGate.getInstalledExpansions(stack)) {
            icon = expansion.getOverlayItem();
            if (icon == null) continue;
            this.renderItem.renderIcon(0, 0, icon, 16, 16);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

