/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class StripesHandlerMinecartDestroy
implements IStripesHandler {
    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.BLOCK_BREAK;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return true;
    }

    @Override
    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        List entities = world.getEntitiesWithinAABBExcludingEntity(null, box);
        if (entities.size() <= 0) {
            return false;
        }
        LinkedList<EntityMinecart> minecarts = new LinkedList<EntityMinecart>();
        for (Object entityObj : entities) {
            if (!(entityObj instanceof EntityMinecart)) continue;
            minecarts.add((EntityMinecart)entityObj);
        }
        if (minecarts.size() > 0) {
            Collections.shuffle(minecarts);
            EntityMinecart cart = (EntityMinecart)minecarts.get(0);
            if (cart instanceof EntityMinecartContainer) {
                EntityMinecartContainer container = (EntityMinecartContainer)cart;
                for (int i = 0; i < container.getSizeInventory(); ++i) {
                    ItemStack s = container.getStackInSlot(i);
                    if (s == null) continue;
                    container.setInventorySlotContents(i, null);
                    if (container.getStackInSlot(i) != null) continue;
                    activator.sendItem(s, direction.getOpposite());
                }
            }
            cart.setDead();
            activator.sendItem(cart.getCartItem(), direction.getOpposite());
            return true;
        }
        return false;
    }
}

