/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet.manager;

import buildcraft.core.tablet.TabletBase;
import java.util.Date;

public class TabletThread
implements Runnable {
    private final TabletBase tablet;
    private long begunTickDate;
    private long lastTickReceivedDate;
    private float ticksLeft = 0.0f;
    private boolean isRunning = false;

    public TabletThread(TabletBase tablet) {
        this.tablet = tablet;
        this.lastTickReceivedDate = this.begunTickDate = new Date().getTime();
    }

    public TabletBase getTablet() {
        return this.tablet;
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            if (this.ticksLeft > 0.0f) {
                this.begunTickDate = new Date().getTime();
                this.tablet.tick(this.ticksLeft);
                float timeElapsed = (float)(this.lastTickReceivedDate - this.begunTickDate) / 1000.0f;
                if (!(timeElapsed > 0.0f)) continue;
                this.ticksLeft -= timeElapsed;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    public void tick(float time) {
        this.ticksLeft += time;
        this.lastTickReceivedDate = new Date().getTime();
    }
}

