/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.common.util.DyeColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemDye;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class ColorButton
extends IconButton {
    private int colorIndex = 0;
    private String tooltipPrefix = "";

    public ColorButton(IGuiScreen gui, int id, int x, int y) {
        super(gui, id, x, y, null);
    }

    public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
        boolean result = super.mousePressed(par1Minecraft, par2, par3);
        if (result) {
            this.nextColor();
        }
        return result;
    }

    @Override
    public boolean mousePressedButton(Minecraft mc, int x, int y, int button) {
        boolean result;
        boolean bl = result = button == 1 && super.checkMousePress(mc, x, y);
        if (result) {
            this.prevColor();
        }
        return result;
    }

    public String getTooltipPrefix() {
        return this.tooltipPrefix;
    }

    public void setToolTipHeading(String tooltipPrefix) {
        this.tooltipPrefix = tooltipPrefix == null ? "" : tooltipPrefix;
    }

    private void nextColor() {
        ++this.colorIndex;
        if (this.colorIndex >= ItemDye.field_150923_a.length) {
            this.colorIndex = 0;
        }
        this.setColorIndex(this.colorIndex);
    }

    private void prevColor() {
        --this.colorIndex;
        if (this.colorIndex < 0) {
            this.colorIndex = ItemDye.field_150923_a.length - 1;
        }
        this.setColorIndex(this.colorIndex);
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = MathHelper.clamp_int((int)colorIndex, (int)0, (int)(ItemDye.field_150923_a.length - 1));
        String colStr = DyeColor.values()[colorIndex].getLocalisedName();
        if (this.tooltipPrefix != null && this.tooltipPrefix.length() > 0) {
            this.setToolTip(this.tooltipPrefix, colStr);
        } else {
            this.setToolTip(colStr);
        }
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        super.drawButton(mc, mouseX, mouseY);
        if (this.visible) {
            Tessellator tes = Tessellator.instance;
            tes.startDrawingQuads();
            int x = this.xPosition + 2;
            int y = this.yPosition + 2;
            GL11.glDisable((int)3553);
            int col = ItemDye.field_150922_c[this.colorIndex];
            tes.setColorOpaque_I(col);
            tes.addVertex((double)x, (double)(y + this.height - 4), (double)this.zLevel);
            tes.addVertex((double)(x + this.width - 4), (double)(y + this.height - 4), (double)this.zLevel);
            tes.addVertex((double)(x + this.width - 4), (double)(y + 0), (double)this.zLevel);
            tes.addVertex((double)x, (double)(y + 0), (double)this.zLevel);
            tes.draw();
            GL11.glEnable((int)3553);
        }
    }
}

