/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class VScrollbar {
    protected final IGuiScreen gui;
    protected int xOrigin;
    protected int yOrigin;
    protected int height;
    protected int xPosition;
    protected int yPosition;
    protected Rectangle wholeArea;
    protected Rectangle btnUp;
    protected Rectangle btnDown;
    protected Rectangle thumbArea;
    protected int scrollPos;
    protected int scrollMax;
    protected boolean pressedUp;
    protected boolean pressedDown;
    protected boolean pressedThumb;
    protected int scrollDir;
    protected long timeNextScroll;

    public VScrollbar(IGuiScreen gui, int xOrigin, int yOrigin, int height) {
        this.gui = gui;
        this.xOrigin = xOrigin;
        this.yOrigin = yOrigin;
        this.height = height;
    }

    public void adjustPosition() {
        this.xPosition = this.xOrigin + this.gui.getGuiLeft();
        this.yPosition = this.yOrigin + this.gui.getGuiTop();
        this.wholeArea = new Rectangle(this.xPosition, this.yPosition, EnderWidget.VSCROLL_THUMB_OFF.width, this.height);
        this.btnUp = new Rectangle(this.xPosition, this.yPosition, EnderWidget.UP_ARROW_OFF.width, EnderWidget.UP_ARROW_OFF.height);
        this.btnDown = new Rectangle(this.xPosition, this.yPosition + Math.max(0, this.height - EnderWidget.DOWN_ARROW_OFF.height), EnderWidget.DOWN_ARROW_OFF.width, EnderWidget.DOWN_ARROW_OFF.height);
        this.thumbArea = new Rectangle(this.xPosition, this.yPosition + this.btnUp.height, EnderWidget.VSCROLL_THUMB_OFF.width, Math.max(0, this.height - (this.btnUp.height + this.btnDown.height)));
    }

    public int getScrollPos() {
        return this.scrollPos;
    }

    public void setScrollPos(int scrollPos) {
        this.scrollPos = this.limitPos(scrollPos);
    }

    public void scrollBy(int amount) {
        this.setScrollPos(this.scrollPos + amount);
    }

    public int getScrollMax() {
        return this.scrollMax;
    }

    public void setScrollMax(int scrollMax) {
        this.scrollMax = scrollMax;
        this.setScrollPos(this.scrollPos);
    }

    public void drawScrollbar(int mouseX, int mouseY) {
        long time;
        EnderWidget iconDown;
        EnderWidget iconUp;
        boolean hoverUp = this.btnUp.contains(mouseX, mouseY);
        boolean hoverDown = this.btnDown.contains(mouseX, mouseY);
        if (this.pressedUp) {
            iconUp = hoverUp ? EnderWidget.UP_ARROW_HOVER_ON : EnderWidget.UP_ARROW_ON;
        } else {
            EnderWidget enderWidget = iconUp = hoverUp ? EnderWidget.UP_ARROW_HOVER_OFF : EnderWidget.UP_ARROW_OFF;
        }
        if (this.pressedDown) {
            iconDown = hoverDown ? EnderWidget.DOWN_ARROW_HOVER_ON : EnderWidget.DOWN_ARROW_ON;
        } else {
            EnderWidget enderWidget = iconDown = hoverDown ? EnderWidget.DOWN_ARROW_HOVER_OFF : EnderWidget.DOWN_ARROW_OFF;
        }
        if (this.scrollDir != 0 && this.timeNextScroll - (time = Minecraft.getSystemTime()) <= 0L) {
            this.timeNextScroll = time + 100L;
            this.scrollBy(this.scrollDir);
        }
        RenderUtil.bindTexture(EnderWidget.TEXTURE);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tes = Tessellator.instance;
        tes.startDrawingQuads();
        iconUp.getMap().render(iconUp, this.btnUp.x, this.btnUp.y, false);
        iconDown.getMap().render(iconDown, this.btnDown.x, this.btnDown.y, false);
        if (this.scrollMax > 0) {
            boolean hoverThumb;
            int thumbPos = this.getThumbPosition();
            boolean bl = hoverThumb = this.thumbArea.contains(mouseX, mouseY) && mouseY >= thumbPos && mouseY < thumbPos + EnderWidget.VSCROLL_THUMB_OFF.height;
            EnderWidget iconThumb = this.pressedThumb ? EnderWidget.VSCROLL_THUMB_HOVER_ON : (hoverThumb ? EnderWidget.VSCROLL_THUMB_HOVER_OFF : EnderWidget.VSCROLL_THUMB_OFF);
            iconThumb.getMap().render(iconThumb, this.thumbArea.x, thumbPos, false);
        }
        tes.draw();
        GL11.glPopAttrib();
    }

    public boolean mouseClicked(int x, int y, int button) {
        if (button == 0) {
            if (this.scrollMax > 0 && this.thumbArea.contains(x, y)) {
                int thumbPos = this.getThumbPosition();
                this.pressedUp = y < thumbPos;
                this.pressedDown = y >= thumbPos + EnderWidget.VSCROLL_THUMB_OFF.height;
                this.pressedThumb = !this.pressedUp && !this.pressedDown;
            } else {
                this.pressedUp = this.btnUp.contains(x, y);
                this.pressedDown = this.btnDown.contains(x, y);
                this.pressedThumb = false;
            }
            this.scrollDir = (this.pressedDown ? 1 : 0) - (this.pressedUp ? 1 : 0);
            if (this.scrollDir != 0) {
                this.timeNextScroll = Minecraft.getSystemTime() + 200L;
                this.scrollBy(this.scrollDir);
            }
        }
        return this.isDragActive();
    }

    public boolean mouseClickMove(int x, int y, int button, long time) {
        if (this.pressedThumb) {
            int pos = y - (this.thumbArea.y + EnderWidget.VSCROLL_THUMB_OFF.height / 2);
            int len = this.thumbArea.height - EnderWidget.VSCROLL_THUMB_OFF.height;
            if (len > 0) {
                this.setScrollPos(Math.round((float)pos * (float)this.scrollMax / (float)len));
            }
            return true;
        }
        return false;
    }

    public void mouseMovedOrUp(int x, int y, int button) {
        this.pressedUp = false;
        this.pressedDown = false;
        this.pressedThumb = false;
        this.scrollDir = 0;
    }

    public void mouseWheel(int x, int y, int delta) {
        if (!this.isDragActive() && this.wholeArea.contains(x, y)) {
            this.scrollBy(-Integer.signum(delta));
        }
    }

    public boolean isDragActive() {
        return this.pressedUp || this.pressedDown || this.pressedThumb;
    }

    protected int getThumbPosition() {
        return this.thumbArea.y + (this.thumbArea.height - EnderWidget.VSCROLL_THUMB_OFF.height) * this.scrollPos / this.scrollMax;
    }

    protected int limitPos(int pos) {
        return Math.max(0, Math.min(pos, this.scrollMax));
    }
}

