/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerEnder<T extends IInventory>
extends Container {
    protected Map<Slot, Point> playerSlotLocations = Maps.newLinkedHashMap();
    protected final int startPlayerSlot;
    protected final int endPlayerSlot;
    protected final int startHotBarSlot;
    protected final int endHotBarSlot;
    @Nonnull
    private final T inv;
    @Nonnull
    private final InventoryPlayer playerInv;

    @Nonnull
    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public ContainerEnder(InventoryPlayer playerInv, T inv) {
        int i;
        this.inv = (IInventory)ContainerEnder.checkNotNull(inv);
        this.playerInv = ContainerEnder.checkNotNull(playerInv);
        this.addSlots(playerInv);
        int x = this.getPlayerInventoryOffset().x;
        int y = this.getPlayerInventoryOffset().y;
        this.startPlayerSlot = this.inventorySlots.size();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                Point loc = new Point(x + j * 18, y + i * 18);
                Slot slot = new Slot((IInventory)playerInv, j + i * 9 + 9, loc.x, loc.y);
                this.addSlotToContainer(slot);
                this.playerSlotLocations.put(slot, loc);
            }
        }
        this.endPlayerSlot = this.inventorySlots.size();
        this.startHotBarSlot = this.inventorySlots.size();
        for (i = 0; i < 9; ++i) {
            Point loc = new Point(x + i * 18, y + 58);
            Slot slot = new Slot((IInventory)playerInv, i, loc.x, loc.y);
            this.addSlotToContainer(slot);
            this.playerSlotLocations.put(slot, loc);
        }
        this.endHotBarSlot = this.inventorySlots.size();
    }

    protected void addSlots(InventoryPlayer playerInv) {
    }

    public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    public Point getUpgradeOffset() {
        return new Point(12, 60);
    }

    @Nonnull
    public T getInv() {
        return this.inv;
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.getInv().isUseableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer p_82846_1_, int p_82846_2_) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(p_82846_2_);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            int minPlayerSlot = this.inventorySlots.size() - this.playerInv.mainInventory.length;
            if (p_82846_2_ < minPlayerSlot ? !this.mergeItemStack(itemstack1, minPlayerSlot, this.inventorySlots.size(), true) : !this.mergeItemStack(itemstack1, 0, minPlayerSlot, false)) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }

    protected boolean mergeItemStack(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        ItemStack itemstack1;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reversOrder) {
            checkIndex = toIndex - 1;
        }
        if (par1ItemStack.isStackable()) {
            while (par1ItemStack.stackSize > 0 && (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.inventorySlots.get(checkIndex);
                itemstack1 = slot.getStack();
                if (itemstack1 != null && itemstack1.getItem() == par1ItemStack.getItem() && (!par1ItemStack.getHasSubtypes() || par1ItemStack.getItemDamage() == itemstack1.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.isItemValid(par1ItemStack) && par1ItemStack != itemstack1) {
                    int mergedSize = itemstack1.stackSize + par1ItemStack.stackSize;
                    int maxStackSize = Math.min(par1ItemStack.getMaxStackSize(), slot.getSlotStackLimit());
                    if (mergedSize <= maxStackSize) {
                        par1ItemStack.stackSize = 0;
                        itemstack1.stackSize = mergedSize;
                        slot.onSlotChanged();
                        result = true;
                    } else if (itemstack1.stackSize < maxStackSize) {
                        par1ItemStack.stackSize -= maxStackSize - itemstack1.stackSize;
                        itemstack1.stackSize = maxStackSize;
                        slot.onSlotChanged();
                        result = true;
                    }
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (par1ItemStack.stackSize > 0) {
            checkIndex = reversOrder ? toIndex - 1 : fromIndex;
            while (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.inventorySlots.get(checkIndex);
                itemstack1 = slot.getStack();
                if (itemstack1 == null && slot.isItemValid(par1ItemStack)) {
                    ItemStack in = par1ItemStack.copy();
                    in.stackSize = Math.min(in.stackSize, slot.getSlotStackLimit());
                    slot.putStack(in);
                    slot.onSlotChanged();
                    par1ItemStack.stackSize = in.stackSize >= par1ItemStack.stackSize ? 0 : (par1ItemStack.stackSize -= in.stackSize);
                    result = true;
                    break;
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }
}

