/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.network.PacketProgress;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityEnder
extends TileEntity {
    private final int checkOffset = (int)(Math.random() * 20.0);
    protected final boolean isProgressTile = this instanceof IProgressTile;
    protected int lastProgressScaled = -1;
    protected int ticksSinceLastProgressUpdate;
    private long lastUpdate = 0L;
    private BlockCoord cachedLocation = null;

    public final boolean canUpdate() {
        return this.shouldUpdate() || this.isProgressTile;
    }

    protected boolean shouldUpdate() {
        return true;
    }

    public final void updateEntity() {
        if (ConfigHandler.allowExternalTickSpeedup || this.worldObj.getTotalWorldTime() != this.lastUpdate) {
            this.lastUpdate = this.worldObj.getTotalWorldTime();
            this.doUpdate();
            if (this.isProgressTile && !this.worldObj.isRemote) {
                int curScaled = this.getProgressScaled(16);
                if (++this.ticksSinceLastProgressUpdate >= this.getProgressUpdateFreq() || curScaled != this.lastProgressScaled) {
                    this.sendTaskProgressPacket();
                    this.lastProgressScaled = curScaled;
                }
            }
        }
    }

    public final int getProgressScaled(int scale) {
        if (this.isProgressTile) {
            return Util.getProgressScaled(scale, (IProgressTile)((Object)this));
        }
        return 0;
    }

    protected void doUpdate() {
    }

    protected void sendTaskProgressPacket() {
        if (this.isProgressTile) {
            EnderPacketHandler.sendToAllAround(new PacketProgress((IProgressTile)((Object)this)), this);
        }
        this.ticksSinceLastProgressUpdate = 0;
    }

    protected int getProgressUpdateFreq() {
        return 20;
    }

    public final void readFromNBT(NBTTagCompound root) {
        super.readFromNBT(root);
        this.readCustomNBT(root);
    }

    public final void writeToNBT(NBTTagCompound root) {
        super.writeToNBT(root);
        this.writeCustomNBT(root);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        return !this.isInvalid() && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    protected abstract void writeCustomNBT(NBTTagCompound var1);

    protected abstract void readCustomNBT(NBTTagCompound var1);

    protected void updateBlock() {
        if (this.worldObj != null) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    protected boolean isPoweredRedstone() {
        return this.worldObj.blockExists(this.xCoord, this.yCoord, this.zCoord) ? this.worldObj.getStrongestIndirectPower(this.xCoord, this.yCoord, this.zCoord) > 0 : false;
    }

    public void init() {
    }

    public BlockCoord getLocation() {
        return this.cachedLocation == null || !this.cachedLocation.equals(this.xCoord, this.yCoord, this.zCoord) ? (this.cachedLocation = new BlockCoord(this)) : this.cachedLocation;
    }

    protected boolean shouldDoWorkThisTick(int interval) {
        return this.shouldDoWorkThisTick(interval, 0);
    }

    protected boolean shouldDoWorkThisTick(int interval, int offset) {
        return (this.worldObj.getTotalWorldTime() + (long)this.checkOffset + (long)offset) % (long)interval == 0L;
    }

    public void setGhostSlotContents(int slot, ItemStack stack) {
    }
}

