/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.EnderCore;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.EntityUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Calendar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.player.AchievementEvent;

@Handlers.Handler
public class FireworkHandler {
    @SubscribeEvent
    public void onAchievement(AchievementEvent event) {
        StatisticsFile file = ((EntityPlayerMP)event.entityPlayer).func_147099_x();
        if (!event.entity.worldObj.isRemote && file.canUnlockAchievement(event.achievement) && !file.hasAchievementUnlocked(event.achievement) && ConfigHandler.betterAchievements) {
            event.entityPlayer.getEntityData().setInteger("fireworksLeft", 9);
            event.entityPlayer.getEntityData().setBoolean("fireworkDelay", false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.worldObj.isRemote && event.phase == TickEvent.Phase.END) {
            int fireworksLeft;
            Calendar cal;
            if (player.worldObj.getTotalWorldTime() % 100L == 0L && (cal = Calendar.getInstance()).get(5) == 1 && cal.get(2) == 0 && !player.getEntityData().getCompoundTag("PlayerPersisted").getBoolean("celebrated")) {
                player.getEntityData().setInteger("fireworksLeft", 15);
                player.getEntityData().setBoolean("fireworkDelay", false);
                NBTTagCompound tag = player.getEntityData().getCompoundTag("PlayerPersisted");
                tag.setBoolean("celebrated", true);
                player.getEntityData().setTag("PlayerPersisted", (NBTBase)tag);
                player.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + EnderCore.lang.localize("celebrate")));
            }
            if (!((fireworksLeft = player.getEntityData().getInteger("fireworksLeft")) <= 0 || player.getEntityData().getBoolean("fireworkDelay") && player.worldObj.getTotalWorldTime() % 20L != 0L)) {
                BlockCoord pos = this.getBlockCoord(player);
                pos = pos.withY(pos.y + 2);
                EntityUtil.spawnFirework(pos, player.worldObj.provider.dimensionId, 12);
                player.getEntityData().setInteger("fireworksLeft", fireworksLeft - 1);
                if (fireworksLeft > 5) {
                    player.getEntityData().setBoolean("fireworkDelay", true);
                } else {
                    player.getEntityData().setBoolean("fireworkDelay", false);
                }
            }
        }
    }

    private BlockCoord getBlockCoord(EntityPlayer player) {
        return new BlockCoord((int)Math.floor(player.posX), (int)Math.floor(player.posY), (int)Math.floor(player.posZ));
    }
}

