/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementDeferred;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

class LazyStructureElement<T>
implements IStructureElementDeferred<T> {
    private Function<T, IStructureElement<T>> to;
    private IStructureElement<T> elem;

    public LazyStructureElement(Function<T, IStructureElement<T>> to) {
        this.to = to;
    }

    private IStructureElement<T> get(T t) {
        if (this.to != null) {
            this.elem = this.to.apply(t);
            this.to = null;
        }
        return this.elem;
    }

    @Override
    public boolean check(T t, World world, int x, int y, int z) {
        return this.get(t).check(t, world, x, y, z);
    }

    @Override
    public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
        return this.get(t).placeBlock(t, world, x, y, z, trigger);
    }

    @Override
    public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
        return this.get(t).spawnHint(t, world, x, y, z, trigger);
    }
}

