/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.CommonProxy;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.api.ItemRandomSkill;
import dynamicswordskills.api.ItemSkillProvider;
import dynamicswordskills.api.WeaponRegistry;
import dynamicswordskills.command.DSSCommands;
import dynamicswordskills.entity.EntityLeapingBlow;
import dynamicswordskills.entity.EntitySwordBeam;
import dynamicswordskills.item.ItemSkillOrb;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="dynamicswordskills", name="Dynamic Sword Skills", version="1.7.10-1.7.1")
public class DynamicSwordSkills {
    @Mod.Instance(value="dynamicswordskills")
    public static DynamicSwordSkills instance;
    @SidedProxy(clientSide="dynamicswordskills.ClientProxy", serverSide="dynamicswordskills.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static boolean isBG2Enabled;
    public static CreativeTabs tabSkills;
    public static Item skillOrb;
    public static List<Item> skillItems;
    public static Item skillWood;
    public static Item skillStone;
    public static Item skillGold;
    public static Item skillIron;
    public static Item skillDiamond;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"zeldaswordskills")) {
            throw new RuntimeException("Dynamic Sword Skills may not be loaded at the same time as Zelda Sword Skills! Please remove one or the other.");
        }
        isBG2Enabled = Loader.isModLoaded((String)"battlegear2");
        Config.init(event);
        tabSkills = new CreativeTabs("dss.skills"){

            @SideOnly(value=Side.CLIENT)
            public Item getTabIconItem() {
                return skillOrb;
            }
        };
        skillOrb = new ItemSkillOrb().setUnlocalizedName("dss.skillorb");
        GameRegistry.registerItem((Item)skillOrb, (String)skillOrb.getUnlocalizedName().substring(5));
        if (Config.areCreativeSwordsEnabled()) {
            skillItems = new ArrayList<Item>(SkillBase.getNumSkills());
            for (SkillBase skill : SkillBase.getSkills()) {
                if (!(skill instanceof SkillActive)) continue;
                int level = skill.getMaxLevel() == 5 ? Config.getSkillSwordLevel() : Config.getSkillSwordLevel() * 2;
                skillItems.add(new ItemSkillProvider(Item.ToolMaterial.IRON, skill, (byte)level).setUnlocalizedName("dss.skillitem" + skill.getId()).setCreativeTab(tabSkills).setTextureName("iron_sword"));
                GameRegistry.registerItem((Item)skillItems.get(skillItems.size() - 1), (String)skillItems.get(skillItems.size() - 1).getUnlocalizedName().substring(5));
            }
        }
        if (Config.areRandomSwordsEnabled()) {
            skillWood = new ItemRandomSkill(Item.ToolMaterial.WOOD).setUnlocalizedName("dss.skillwood").setTextureName("wood_sword");
            GameRegistry.registerItem((Item)skillWood, (String)skillWood.getUnlocalizedName().substring(5));
            skillStone = new ItemRandomSkill(Item.ToolMaterial.STONE).setUnlocalizedName("dss.skillstone").setTextureName("stone_sword");
            GameRegistry.registerItem((Item)skillStone, (String)skillStone.getUnlocalizedName().substring(5));
            skillGold = new ItemRandomSkill(Item.ToolMaterial.GOLD).setUnlocalizedName("dss.skillgold").setTextureName("gold_sword");
            GameRegistry.registerItem((Item)skillGold, (String)skillGold.getUnlocalizedName().substring(5));
            skillIron = new ItemRandomSkill(Item.ToolMaterial.IRON).setUnlocalizedName("dss.skilliron").setTextureName("iron_sword");
            GameRegistry.registerItem((Item)skillIron, (String)skillIron.getUnlocalizedName().substring(5));
            skillDiamond = new ItemRandomSkill(Item.ToolMaterial.EMERALD).setUnlocalizedName("dss.skilldiamond").setTextureName("diamond_sword");
            GameRegistry.registerItem((Item)skillDiamond, (String)skillDiamond.getUnlocalizedName().substring(5));
        }
        EntityRegistry.registerModEntity(EntityLeapingBlow.class, (String)"leapingblow", (int)0, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySwordBeam.class, (String)"swordbeam", (int)1, (Object)this, (int)64, (int)10, (boolean)true);
        PacketDispatcher.initialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
        DSSCombatEvents events = new DSSCombatEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        FMLCommonHandler.instance().bus().register((Object)events);
        DSSCombatEvents.initializeDrops();
        if (Config.getLootWeight() > 0) {
            this.registerSkillOrbLoot();
        }
        if (Config.areRandomSwordsEnabled()) {
            this.registerRandomSwordLoot();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        String link = "https://raw.githubusercontent.com/coolAlias/DynamicSwordSkills/master/src/main/resources/versionlist.json";
        FMLInterModComms.sendRuntimeMessage((Object)"dynamicswordskills", (String)"VersionChecker", (String)"addVersionCheck", (String)link);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.postInit();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        DSSCommands.registerCommands(event);
    }

    @Mod.EventHandler
    public void processMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            WeaponRegistry.INSTANCE.processMessage(msg);
        }
    }

    private void registerSkillOrbLoot() {
        for (SkillBase skill : SkillBase.getSkills()) {
            if (!Config.isSkillEnabled(skill.getId())) continue;
            this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillOrb, 1, (int)skill.getId()), 1, 1, Config.getLootWeight()), false);
        }
    }

    private void registerRandomSwordLoot() {
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillWood), 1, 1, 4), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillStone), 1, 1, 3), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillGold), 1, 1, 2), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillIron), 1, 1, 2), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillDiamond), 1, 1, 1), false);
    }

    private void addLootToAll(WeightedRandomChestContent loot, boolean bonus) {
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(loot);
        ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(loot);
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(loot);
        if (bonus) {
            ChestGenHooks.getInfo((String)"bonusChest").addItem(loot);
        }
    }

    static {
        logger = LogManager.getLogger((String)"dynamicswordskills");
    }
}

