/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ItemRandomSkill
extends ItemSword
implements ISkillProvider {
    private final byte maxLevel;

    public ItemRandomSkill(Item.ToolMaterial material) {
        super(material);
        this.maxLevel = (byte)(2 + material.getHarvestLevel());
        this.setCreativeTab(null);
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return true;
    }

    protected SkillBase getSkill(ItemStack stack) {
        return stack.hasTagCompound() ? SkillBase.getSkillFromItem(stack, this) : null;
    }

    @Override
    public int getSkillId(ItemStack stack) {
        return stack.hasTagCompound() && stack.getTagCompound().hasKey("ItemSkillId") ? stack.getTagCompound().getInteger("ItemSkillId") : -1;
    }

    @Override
    public byte getSkillLevel(ItemStack stack) {
        return stack.hasTagCompound() && stack.getTagCompound().hasKey("ItemSkillLevel") ? stack.getTagCompound().getByte("ItemSkillLevel") : (byte)0;
    }

    @Override
    public boolean grantsBasicSwordSkill(ItemStack stack) {
        return stack.hasTagCompound() && stack.getTagCompound().getBoolean("grantsBasicSword");
    }

    public String getItemStackDisplayName(ItemStack stack) {
        SkillBase skill = this.getSkill(stack);
        return StatCollector.translateToLocalFormatted((String)"item.dss.skillitem.name", (Object[])new Object[]{skill == null ? "" : skill.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        SkillBase skill = this.getSkill(stack);
        if (skill != null) {
            list.add(StatCollector.translateToLocalFormatted((String)"tooltip.dss.skillprovider.desc.skill", (Object[])new Object[]{EnumChatFormatting.GOLD + skill.getDisplayName()}));
            list.add(StatCollector.translateToLocalFormatted((String)"tooltip.dss.skillprovider.desc.level", (Object[])new Object[]{skill.getLevel(), skill.getMaxLevel()}));
            if (this.grantsBasicSwordSkill(stack)) {
                list.add(StatCollector.translateToLocalFormatted((String)"tooltip.dss.skillprovider.desc.provider", (Object[])new Object[]{EnumChatFormatting.DARK_GREEN + SkillBase.swordBasic.getDisplayName()}));
            }
            list.addAll(skill.getDescription(player));
        }
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rand, WeightedRandomChestContent original) {
        SkillBase skill = null;
        while (skill == null) {
            skill = SkillBase.getSkill(rand.nextInt(SkillBase.getNumSkills()));
            if (skill instanceof SkillActive && Config.isSkillEnabled(skill.getId())) continue;
            skill = null;
        }
        ItemStack loot = new ItemStack((Item)this);
        loot.setTagCompound(this.getRandomSkillTag(skill, rand));
        return new WeightedRandomChestContent(loot, original.theMinimumChanceToGenerateItem, original.theMaximumChanceToGenerateItem, original.itemWeight);
    }

    private NBTTagCompound getRandomSkillTag(SkillBase skill, Random rand) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("ItemSkillId", (int)skill.getId());
        int level = 1 + rand.nextInt(Math.min(this.maxLevel, skill.getMaxLevel()));
        tag.setByte("ItemSkillLevel", (byte)level);
        tag.setBoolean("grantsBasicSword", skill.getId() != SkillBase.swordBasic.getId() && rand.nextInt(16) > 4);
        return tag;
    }
}

