/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSkillProvider
extends Item
implements ISkillProvider {
    private final Item.ToolMaterial material;
    private float weaponDamage;
    private final byte skillId;
    private final byte level;
    private SkillBase skill;
    private final boolean grantsBasicSkill;

    public ItemSkillProvider(Item.ToolMaterial material, SkillBase skill, byte level) {
        this(material, skill, level, true);
    }

    public ItemSkillProvider(Item.ToolMaterial material, SkillBase skill, byte level, boolean grantsBasicSkill) {
        this.material = material;
        this.weaponDamage = 4.0f + this.material.getDamageVsEntity();
        this.skillId = skill.getId();
        this.level = level;
        this.grantsBasicSkill = grantsBasicSkill;
        this.setMaxDamage(this.material.getMaxUses());
        this.setMaxStackSize(1);
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return true;
    }

    protected SkillBase getSkill(ItemStack stack) {
        if (this.skill == null) {
            this.skill = SkillBase.getSkillFromItem(stack, this);
        }
        return this.skill;
    }

    @Override
    public int getSkillId(ItemStack stack) {
        return this.skillId;
    }

    @Override
    public byte getSkillLevel(ItemStack stack) {
        return this.level;
    }

    @Override
    public boolean grantsBasicSwordSkill(ItemStack stack) {
        return this.grantsBasicSkill;
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.damageItem(1, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public int getItemEnchantability() {
        return this.material.getEnchantability();
    }

    public boolean getIsRepairable(ItemStack toRepair, ItemStack stack) {
        return this.material.func_150995_f() == stack.getItem() ? true : super.getIsRepairable(toRepair, stack);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if ((double)block.getBlockHardness(world, x, y, z) != 0.0) {
            stack.damageItem(2, entity);
        }
        return true;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        SkillBase skill = this.getSkill(stack);
        return StatCollector.translateToLocalFormatted((String)"item.dss.skillitem.name", (Object[])new Object[]{skill == null ? "" : skill.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        SkillBase skill = this.getSkill(stack);
        if (skill != null) {
            list.add(StatCollector.translateToLocalFormatted((String)"tooltip.dss.skillprovider.desc.skill", (Object[])new Object[]{EnumChatFormatting.GOLD + skill.getDisplayName()}));
            list.add(StatCollector.translateToLocalFormatted((String)"tooltip.dss.skillprovider.desc.level", (Object[])new Object[]{skill.getLevel(), skill.getMaxLevel()}));
            if (this.grantsBasicSwordSkill(stack)) {
                list.add(StatCollector.translateToLocalFormatted((String)"tooltip.dss.skillprovider.desc.provider", (Object[])new Object[]{EnumChatFormatting.DARK_GREEN + SkillBase.swordBasic.getDisplayName()}));
            }
            list.addAll(skill.getDescription(player));
        }
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
        return multimap;
    }
}

